BattleBit = {
    settings =
    {
        port = 29991,
        Hz = 60,
        AntiCheat = false,
        MaxPing = 30,
        VoxelMode = 'Mode1',
        ApiEndpoint = '',
        FixedSize = 'big',
        FirstGamemode = 'DOMI',
        FirstMap = 'WAKISTAN',
        MaxPlayers = 10,
        LogLocation = '',
        Password = '',
        logFile = ''
    },
    location = application_path()
}
BattleBit.__index = BattleBit

function BattleBit:set_log_file(location)
    self.settings.logFile = location
end

function BattleBit:get_log_file()
    return self.settings.logFile
end

function BattleBit:set_port(portnum)
    self.settings.port = portnum
end

function BattleBit:get_port()
    return self.settings.port
end

function BattleBit:set_hz(hz)
    self.settings.Hz = hz
end

function BattleBit:get_hz()
    return self.settings.Hz
end

function BattleBit:set_anti_cheat(anti_cheat)
    self.settings.AntiCheat = anti_cheat
end

function BattleBit:get_anti_cheat()
    return self.settings.AntiCheat
end

function BattleBit:set_max_ping(max_ping)
    self.settings.MaxPing = max_ping
end

function BattleBit:get_max_ping()
    return self.settings.MaxPing
end

function BattleBit:set_voxel_mode(voxel_mode)
    self.settings.VoxelMode = voxel_mode
end

function BattleBit:get_voxel_mode()
    return self.settings.VoxelMode
end

function BattleBit:set_api_endpoint(endpoint)
    self.settings.ApiEndpoint = endpoint
end

function BattleBit:get_api_endpoint()
    return self.settings.ApiEndpoint
end

function BattleBit:set_location(location)
    self.location = location
end

function BattleBit:get_location()
    return self.location
end

function BattleBit:new(o)
    o = o or {}
    setmetatable(o, self)
    o.__index = self
    return o
end

function BattleBit:launch_local()
    local composed = {}
    local system_location = path_append(self.location, "BattleBit.exe")
    local battlebit_location = '"' .. system_location .. '"'
    if is_linux() then
        local newlocation = 'Z:'
        for i = 1, string.len(battlebit_location) do
            local char = string.sub(battlebit_location, i, i)
            if char == '/' then
                newlocation = newlocation .. '\\'
            else
                newlocation = newlocation .. char
            end
        end
        composed = {'/bin/sh', '-c', '\'wine', 'cmd.exe', "/C", battlebit_location, '-nographics', '-batchmode'}
    elseif is_windows() then
        composed = {'cmd.exe', '/C', battlebit_location, '-batchmode', '-nographics'}
    end
    for i, v in pairs(self.settings) do
        local string_convert = ''
        if type(v) == 'boolean' then
            if v == true then
                v = 'true'
            else
                v = 'false'
            end
        elseif type(v) == 'string' and string.len(v) >= 0 then
            string_convert = '-' .. i .. '=' .. v
        elseif type(v) == 'number' then
            string_convert = '-' .. i .. '=' .. v
        end
        composed[#composed + 1] = string_convert
    end
    if is_linux() then
        composed[#composed + 1] = '\''
    end
    local t = table.concat(composed, ' ')
    return t
end

BattleBitInterface = {
    instance = BattleBit:new(),
    display_order = {
        'location',
        'log_file',
        'generate_temp_log',
        'port',
        'hz',
        'anti_cheat',
        'max_ping',
        'voxel_mode',
        'api_endpoint',
        'local_launch'
    },
    schema =
    {
        ['location'] = {
            description = 'BattleBit root directory',
            type = DirectoryBrowse,
            default = BattleBit.location,
            setter = function(location)
                local corrected_location = ''
                if directory_exists(location) then
                    corrected_location = location
                end
                BattleBitInterface.instance:set_location(corrected_location)
            end,
            getter = function() return BattleBitInterface.instance:get_location() end
        },
        ['log_file'] = {
            description = 'Log File',
            type = String,
            default = BattleBit.settings.logFile,
            setter = function(location)
                BattleBitInterface.instance:set_log_file(location)
            end,
            getter = function()
                return BattleBitInterface.instance:get_log_file()
            end
        },
        ['generate_temp_log'] = {
            description = 'Generate Temp File for Log',
            type = Button,
            action = function()
                BattleBitInterface.instance:set_log_file('hook needs to be implemented')
            end,
            setter = function(v) end,
            getter = function() return 'Generate Temp File for Log' end
        },
        ['port'] =
        {
            description = 'Port',
            type = Integer,
            default =  BattleBit.settings.port,
            setter = function(port)
                BattleBitInterface.instance:set_port(port)
            end,
            getter = function()
                return BattleBitInterface.instance:get_port()
            end
        },
        ['hz'] =
        {
            description = 'Hz',
            type = Integer,
            default =  BattleBit.settings.Hz,
            setter = function(hz)
                BattleBitInterface.instance:set_hz(hz)
            end,
            getter = function()
                return BattleBitInterface.instance:get_hz()
            end
        },
        ['anti_cheat'] = {
            description = 'Anti-Cheat',
            type = Boolean,
            default =  BattleBit.settings.AntiCheat,
            setter = function(anti_cheat)
                BattleBitInterface.instance:set_anti_cheat(anti_cheat)
            end,
            getter = function()
                return BattleBitInterface.instance:get_anti_cheat()
            end
        },
        ['max_ping'] = {
            description = 'Max Ping',
            type = IntegerRange,
            minimum = 0,
            maximum = 100000,
            default =  BattleBit.settings.MaxPing,
            setter = function(max_ping)
                BattleBitInterface.instance:set_max_ping(max_ping)
            end,
            getter = function()
                return BattleBitInterface.instance:get_max_ping()
            end
        },
        ['voxel_mode'] =
        {
            description = 'Voxel Mode',
            type = Enum,
            default = 'Mode1',
            values = { 'Mode1', 'Mode2' },
            setter = function(voxel_mode)
                local voxel_string = BattleBitInterface.schema.voxel_mode.values[voxel_mode + 1]
                BattleBitInterface.instance:set_voxel_mode(voxel_string)
            end,
            getter = function()
                local vmode = BattleBitInterface.instance:get_voxel_mode()
                return vmode
            end
        },
        ['api_endpoint'] =
        {
            description = 'API Endpoint',
            type = String,
            default =  BattleBit.settings.ApiEndpoint,
            setter = function(api_endpoint)
                BattleBitInterface.instance:set_api_endpoint(api_endpoint)
            end,
            getter = function()
                return BattleBitInterface.instance:get_api_endpoint()
            end
        },
        ['local_launch'] =
        {
            description = 'Launch locally',
            type = Button,
            action = function()
                print('Command line that would launch:')
                print(BattleBitInterface.instance:launch_local())
            end,
            setter = function(v) BattleBitInterface.schema.local_launch.description = v end,
            getter = function() return BattleBitInterface.schema.local_launch.description end
        },
        ['debug_element'] =
        {
            description = 'Debug',
            type = Button,
            action = function()
                print('Debug')
            end,
            setter = function(v) end,
            getter = function() return 'Debug' end
        }
    }
}

register_plugin('BattleBit', 'Local Deploy', BattleBitInterface)