user_styles = {
    ['Green'] = {
        green = {red = 168, green = 101, blue = 35 },
        red = {red = 130, green = 3, blue = 0 },
        blue = {red = 96, green = 123, blue =  143},
        foreground = {red = 220, green = 220, blue = 220 },
        background = {red = 85, green = 97, blue = 81 },
        background2 = {red = 60, green = 61, blue = 55 }
    },
    ['Nord'] = {
        green = {red = 163, green = 190, blue = 140 },
        red = {red = 191, green = 97, blue = 106 },
        blue = {red = 136, green = 192, blue = 208},
        foreground = {red = 220, green = 220, blue = 220 },
        background = {red = 67, green = 76, blue = 94 },
        background2 = {red = 59, green = 66, blue = 82 }
    },
    ['DefaultDark'] = {
        red = {red = 54, green = 56, blue = 62 },
        green = {red = 115, green = 158, blue = 201 },
        blue = {red = 115, green = 158, blue = 201 },
        -- blue = {red = 81, green = 160, blue = 201 },
        foreground = {red = 220, green = 220, blue = 220 },
        background = {red = 30, green = 32, blue = 38 },
        background2 = {red = 54, green = 56, blue = 62 }
    }
}

window = {
    width = 1050,
    height = 768,
    widget_width = 738,
    sidebar_width = 300,
    style = user_styles['Nord']
}

-- theme = 'plastic'
-- theme = 'gtk+'
-- theme = 'gleam'
-- theme = 'none'
theme = 'base'

plugin_folder = 'supported'

online_plugins = {}

plugins = {
    path_append(plugin_folder, 'zomboid_main.lua'),
    path_append(plugin_folder, 'zomboid_server.lua'),
    path_append(plugin_folder, 'zomboid_sandbox.lua'),
    path_append(plugin_folder, 'zomboid.lua'),
    path_append(plugin_folder, 'dummy.lua'),
    path_append(plugin_folder, 'battlebit.lua')
}

function retrieve_online_plugin(endpoint)
    local filename = ''
    local index = string.len(endpoint)
    local plugin_folder_fullpath = path_append(application_path(), plugin_folder)
    while string.sub(endpoint, index, index) ~= '/' do
        filename = string.sub(endpoint, index, index) .. filename
        index = index - 1
    end
    local output_path = path_append(plugin_folder_fullpath, filename)
    local attempt_retrieval = filename and not file_exists(output_path)
    if attempt_retrieval and is_windows() then
        os.execute('powershell.exe -Command "Invoke-WebRequest \'' .. endpoint .. '\' -OutFile \'' .. output_path .. '\'"')
    elseif attempt_retrieval and is_linux() then
        print('executing curl')
        local ex = '/bin/sh -c \'curl -s -L -o \'"\'"\''
          .. output_path
          .. '\'"\'"\' \'"\'"\'' .. endpoint
          .. '\'"\'"'
        print(ex)
        os.execute(ex)
    end
    if file_exists(output_path) then
        plugins[#plugins+1] = plugin_folder .. '/' .. filename
    end
end

for i = 1, #online_plugins do
    retrieve_online_plugin(online_plugins[i])
end

for i = 1, #plugins do
    load_plugin(plugins[i])
end
