ZomboidServerFunctions = {
  get_status = function()
    return false
  end,

  get_user_home_directory = function()
    local home_directory = ''
    if is_windows() then
      home_directory =
           (os.getenv('HOMEDRIVE') or '')
        .. (os.getenv('HOMEPATH')  or '')
    elseif is_linux() then
      home_directory = os.getenv('HOME') or ''
    else
      home_directory = ''
    end
    if directory_exists(home_directory) then
      home_directory = path_append(home_directory, 'Zomboid')
      if not directory_exists(home_directory) then
        home_directory = ''
      end
    else
      home_directory = ''
    end
    return home_directory
  end,
}

ZomboidHome =
{
  state =
  {
    zomboid_dir = '',
    server_list = {},
  },
  display_order = {
    'ZomboidHomeHeader',
    'ZomboidDir',
    '_Spacer1',
    'PrimaryGroup',
    'StatusIndicator',
    'ConnectionInfo',
    'ServerVars',
    'SandboxVars',
    'CPUUsage',
    'PrimaryGroupSplit',
    'MemoryUsage',
    'Players',
    'FileBrowser',
    'Terminal',
    'Database',
    'ServerMaintenance',
    'BackupServer',
    'RestoreBackup',
  },
  schema =
  {
    ['ZomboidHomeHeader'] =
    {
      type = Label,
      description = 'Project Zomboid'
    },
    ['ZomboidDir'] = {
      value = '',
      description = 'Local Zomboid Path',
      type = DirectoryBrowse,
      default = ZomboidServerFunctions.get_user_home_directory(),
      setter = function(v)
        ZomboidHome.state.zomboid_dir = v
      end,
      getter = function()
        return ZomboidHome.state.zomboid_dir
      end
    },
    ['_Spacer1'] = {
      type = Spacer,
    },
    ['PrimaryGroup'] = {
      type = Group,
      height = 10,
      schema = {
        ['StatusIndicator'] =
        {
          type = Boolean,
          description = 'Current Status',
          setter = function(v) end,
          getter = function()
            return ZomboidServerFunctions.get_status()
          end
        },
        ['ConnectionInfo'] =
        {
          type = String,
          description = 'Connection Information',
          setter = function(v) end,
          getter = function() return '' end
        },
        ['ServerVars'] =
        {
          type = Button,
          default = 'Server Variables',
          action = function()
            change_interface('Local Administration/Zomboid/Server Config')
          end
        },
        ['SandboxVars'] =
        {
          type = Button,
          default = 'Sandbox Variables',
          action = function()
            change_interface('Local Administration/Zomboid/Sandbox Config')
          end
        },
        ['PrimaryGroupSplit'] =
        {
          type = VSplit
        },
        ['CPUUsage'] =
        {
          type = String,
          description = 'CPU Usage',
          default = '0%'
        },
        ['MemoryUsage'] =
        {
          type = String,
          description = 'Memory Usage',
          default = '0%'
        },
        ['Players'] =
        {
          type = String,
          description = 'Players',
          default = '0%',
        },
        ['FileBrowser'] =
        {
          type = Button,
          default = 'File Browser'
        },
        ['Terminal'] =
        {
          type = Button,
          default = 'Terminal',
        },
        ['Database'] =
        {
          type = Button,
          default = 'Database',
        },
        ['ServerMaintenance'] =
        {
          type = Label,
          description = 'Server Maintenance'
        },
        ['BackupServer'] =
        {
          type = Button,
          default = 'Backup Server',
        },
        ['RestoreBackup'] =
        {
          type = Button,
          default = 'Restore Backup',
        }
      }
    }
  }
}

register_plugin('Zomboid', ZomboidHome)
