ZomboidSandbox = {
    version = 5,
    settings = {
        Zombies = nil,
        Distribution = nil,
        DayLength = nil,
        StartYear = nil,
        StartMonth = nil,
        StartDay = nil,
        StartTime = nil,
        WaterShut = nil,
        ElecShut = nil,
        WaterShutModifier = nil,
        ElecShutModifier = nil,
        FoodLoot = nil,
        CannedFoodLoot = nil,
        LiteratureLoot = nil,
        SurvivalGearsLoot = nil,
        MedicalLoot = nil,
        WeaponLoot = nil,
        RangedWeaponLoot = nil,
        AmmoLoot = nil,
        MechanicsLoot = nil,
        OtherLoot = nil,
        Temperature = nil,
        Rain = nil,
        ErosionSpeed = nil,
        ErosionDays = nil,
        XpMultiplier = nil,
        XpMultiplierAffectsPassive = nil,
        ZombieAttractionMultiplier = nil,
        VehicleEasyUse = nil,
        Farming = nil,
        CompostTime = nil,
        StatsDecrease = nil,
        NatureAbundance = nil,
        Alarm = nil,
        LockedHouses = nil,
        StarterKit = nil,
        Nutrition = nil,
        FoodRotSpeed = nil,
        FridgeFactor = nil,
        LootRespawn = nil,
        SeenHoursPreventLootRespawn = nil,
        WorldItemRemovalList = nil,
        HoursForWorldItemRemoval = nil,
        ItemRemovalListBlacklistToggle = nil,
        TimeSinceApo = nil,
        PlantResilience = nil,
        PlantAbundance = nil,
        EndRegen = nil,
        Helicopter = nil,
        MetaEvent = nil,
        SleepingEvent = nil,
        GeneratorSpawning = nil,
        GeneratorFuelConsumption = nil,
        SurvivorHouseChance = nil,
        VehicleStoryChance = nil,
        ZoneStoryChance = nil,
        AnnotatedMapChance = nil,
        CharacterFreePoints = nil,
        ConstructionBonusPoints = nil,
        NightDarkness = nil,
        NightLength = nil,
        InjurySeverity = nil,
        BoneFracture = nil,
        HoursForCorpseRemoval = nil,
        DecayingCorpseHealthImpact = nil,
        BloodLevel = nil,
        ClothingDegradation = nil,
        FireSpread = nil,
        DaysForRottenFoodRemoval = nil,
        AllowExteriorGenerator = nil,
        MaxFogIntensity = nil,
        MaxRainFxIntensity = nil,
        EnableSnowOnGround = nil,
        MultiHitZombies = nil,
        RearVulnerability = nil,
        AttackBlockMovements = nil,
        AllClothesUnlocked = nil,
        EnableTaintedWaterText = nil,
        CarSpawnRate = nil,
        ChanceHasGas = nil,
        InitialGas = nil,
        FuelStationGas = nil,
        CarGasConsumption = nil,
        LockedCar = nil,
        CarGeneralCondition = nil,
        CarDamageOnImpact = nil,
        DamageToPlayerFromHitByACar = nil,
        TrafficJam = nil,
        CarAlarm = nil,
        PlayerDamageFromCrash = nil,
        SirenShutoffHours = nil,
        RecentlySurvivorVehicles = nil,
        EnableVehicles = nil,
        EnablePoisoning = nil,
        MaggotSpawn = nil,
        LightBulbLifespan = nil,
        Map = {
            AllowMiniMap = nil,
            AllowWorldMap = nil,
            AllKnown = nil
        },
        ZombieLore = {
            Speed = nil,
            Strength = nil,
            Toughness = nil,
            Transmission = nil,
            Mortality = nil,
            Reanimate = nil,
            Cognition = nil,
            CrawlUnderVehicle = nil,
            Memory = nil,
            Sight = nil,
            Hearing = nil,
            ThumpNoChasing = nil,
            ThumpOnConstruction = nil,
            ActiveOnly = nil,
            TriggerHouseAlarm = nil,
            ZombiesDragDown = nil,
            ZombiesFenceLunge = nil,
            DisableFakeDead = nil
        },
        ZombieConfig = {
            PopulationMultiplier = nil,
            PopulationStartMultiplier = nil,
            PopulationPeakMultiplier = nil,
            PopulationPeakDay = nil,
            RespawnHours = nil,
            RespawnUnseenHours = nil,
            RespawnMultiplier = nil,
            RedistributeHours = nil,
            FollowSoundDistance = nil,
            RallyGroupSize = nil,
            RallyTravelDistance = nil,
            RallyGroupSeparation = nil,
            RallyGroupRadius = nil
        }
    }
}

ZomboidSandbox.__index = ZomboidSandbox

function ZomboidSandbox:set_ZombieConfig_PopulationMultiplier(v)
    self.settings.ZombieConfig.PopulationMultiplier = v
end

function ZomboidSandbox:get_ZombieConfig_PopulationMultiplier()
    return self.settings.ZombieConfig.PopulationMultiplier
end

function ZomboidSandbox:set_ZombieConfig_PopulationStartMultiplier(v)
    self.settings.ZombieConfig.PopulationStartMultiplier = v
end

function ZomboidSandbox:get_ZombieConfig_PopulationStartMultiplier()
    return self.settings.ZombieConfig.PopulationStartMultiplier
end

function ZomboidSandbox:set_ZombieConfig_PopulationPeakMultiplier(v)
    self.settings.ZombieConfig.PopulationPeakMultiplier = v
end

function ZomboidSandbox:get_ZombieConfig_PopulationPeakMultiplier()
    return self.settings.ZombieConfig.PopulationPeakMultiplier
end

function ZomboidSandbox:set_ZombieConfig_PopulationPeakDay(v)
    self.settings.ZombieConfig.PopulationPeakDay = v
end

function ZomboidSandbox:get_ZombieConfig_PopulationPeakDay()
    return self.settings.ZombieConfig.PopulationPeakDay
end

function ZomboidSandbox:set_ZombieConfig_RespawnHours(v)
    self.settings.ZombieConfig.RespawnHours = v
end

function ZomboidSandbox:get_ZombieConfig_RespawnHours()
    return self.settings.ZombieConfig.RespawnHours
end

function ZomboidSandbox:set_ZombieConfig_RespawnUnseenHours(v)
    self.settings.ZombieConfig.RespawnUnseenHours = v
end

function ZomboidSandbox:get_ZombieConfig_RespawnUnseenHours()
    return self.settings.ZombieConfig.RespawnUnseenHours
end

function ZomboidSandbox:set_ZombieConfig_RespawnMultiplier(v)
    self.settings.ZombieConfig.RespawnMultiplier = v
end

function ZomboidSandbox:get_ZombieConfig_RespawnMultiplier()
    return self.settings.ZombieConfig.RespawnMultiplier
end

function ZomboidSandbox:set_ZombieConfig_RedistributeHours(v)
    self.settings.ZombieConfig.RedistributeHours = v
end

function ZomboidSandbox:get_ZombieConfig_RedistributeHours()
    return self.settings.ZombieConfig.RedistributeHours
end

function ZomboidSandbox:set_ZombieConfig_FollowSoundDistance(v)
    self.settings.ZombieConfig.FollowSoundDistance = v
end

function ZomboidSandbox:get_ZombieConfig_FollowSoundDistance()
    return self.settings.ZombieConfig.FollowSoundDistance
end

function ZomboidSandbox:set_ZombieConfig_RallyGroupSize(v)
    self.settings.ZombieConfig.RallyGroupSize = v
end

function ZomboidSandbox:get_ZombieConfig_RallyGroupSize()
    return self.settings.ZombieConfig.RallyGroupSize
end

function ZomboidSandbox:set_ZombieConfig_RallyTravelDistance(v)
    self.settings.ZombieConfig.RallyTravelDistance = v
end

function ZomboidSandbox:get_ZombieConfig_RallyTravelDistance()
    return self.settings.ZombieConfig.RallyTravelDistance
end

function ZomboidSandbox:set_ZombieConfig_RallyGroupSeparation(v)
    self.settings.ZombieConfig.RallyGroupSeparation = v
end

function ZomboidSandbox:get_ZombieConfig_RallyGroupSeparation()
    return self.settings.ZombieConfig.RallyGroupSeparation
end

function ZomboidSandbox:set_ZombieConfig_RallyGroupRadius(v)
    self.settings.ZombieConfig.RallyGroupRadius = v
end

function ZomboidSandbox:get_ZombieConfig_RallyGroupRadius()
    return self.settings.ZombieConfig.RallyGroupRadius
end

function ZomboidSandbox:set_Map_AllowMiniMap(v)
    self.settings.Map.AllowMiniMap = v
end

function ZomboidSandbox:get_Map_AllowMiniMap()
    return self.settings.Map.AllowMiniMap
end

function ZomboidSandbox:set_Map_AllowWorldMap(v)
    self.settings.Map.AllowWorldMap = v
end

function ZomboidSandbox:get_Map_AllowWorldMap()
    return self.settings.Map.AllowWorldMap
end

function ZomboidSandbox:set_Map_AllKnown(v)
    self.settings.Map.AllKnown = v
end

function ZomboidSandbox:get_Map_AllKnown()
    return self.settings.Map.AllKnown
end

function ZomboidSandbox:set_ZombieLore_Speed(v)
    self.settings.ZombieLore.Speed = v
end

function ZomboidSandbox:get_ZombieLore_Speed()
    return self.settings.ZombieLore.Speed
end
function ZomboidSandbox:set_ZombieLore_Strength(v)
    self.settings.ZombieLore.Strength = v
end

function ZomboidSandbox:get_ZombieLore_Strength()
    return self.settings.ZombieLore.Strength
end
function ZomboidSandbox:set_ZombieLore_Toughness(v)
    self.settings.ZombieLore.Toughness = v
end

function ZomboidSandbox:get_ZombieLore_Toughness()
    return self.settings.ZombieLore.Toughness
end
function ZomboidSandbox:set_ZombieLore_Transmission(v)
    self.settings.ZombieLore.Transmission = v
end

function ZomboidSandbox:get_ZombieLore_Transmission()
    return self.settings.ZombieLore.Transmission
end
function ZomboidSandbox:set_ZombieLore_Mortality(v)
    self.settings.ZombieLore.Mortality = v
end

function ZomboidSandbox:get_ZombieLore_Mortality()
    return self.settings.ZombieLore.Mortality
end
function ZomboidSandbox:set_ZombieLore_Reanimate(v)
    self.settings.ZombieLore.Reanimate = v
end

function ZomboidSandbox:get_ZombieLore_Reanimate()
    return self.settings.ZombieLore.Reanimate
end
function ZomboidSandbox:set_ZombieLore_Cognition(v)
    self.settings.ZombieLore.Cognition = v
end

function ZomboidSandbox:get_ZombieLore_Cognition()
    return self.settings.ZombieLore.Cognition
end
function ZomboidSandbox:set_ZombieLore_CrawlUnderVehicle(v)
    self.settings.ZombieLore.CrawlUnderVehicle = v
end

function ZomboidSandbox:get_ZombieLore_CrawlUnderVehicle()
    return self.settings.ZombieLore.CrawlUnderVehicle
end
function ZomboidSandbox:set_ZombieLore_Memory(v)
    self.settings.ZombieLore.Memory = v
end

function ZomboidSandbox:get_ZombieLore_Memory()
    return self.settings.ZombieLore.Memory
end
function ZomboidSandbox:set_ZombieLore_Sight(v)
    self.settings.ZombieLore.Sight = v
end

function ZomboidSandbox:get_ZombieLore_Sight()
    return self.settings.ZombieLore.Sight
end
function ZomboidSandbox:set_ZombieLore_Hearing(v)
    self.settings.ZombieLore.Hearing = v
end

function ZomboidSandbox:get_ZombieLore_Hearing()
    return self.settings.ZombieLore.Hearing
end
function ZomboidSandbox:set_ZombieLore_ThumpNoChasing(v)
    self.settings.ZombieLore.ThumpNoChasing = v
end

function ZomboidSandbox:get_ZombieLore_ThumpNoChasing()
    return self.settings.ZombieLore.ThumpNoChasing
end
function ZomboidSandbox:set_ZombieLore_ThumpOnConstruction(v)
    self.settings.ZombieLore.ThumpOnConstruction = v
end

function ZomboidSandbox:get_ZombieLore_ThumpOnConstruction()
    return self.settings.ZombieLore.ThumpOnConstruction
end
function ZomboidSandbox:set_ZombieLore_ActiveOnly(v)
    self.settings.ZombieLore.ActiveOnly = v
end

function ZomboidSandbox:get_ZombieLore_ActiveOnly()
    return self.settings.ZombieLore.ActiveOnly
end
function ZomboidSandbox:set_ZombieLore_TriggerHouseAlarm(v)
    self.settings.ZombieLore.TriggerHouseAlarm = v
end

function ZomboidSandbox:get_ZombieLore_TriggerHouseAlarm()
    return self.settings.ZombieLore.TriggerHouseAlarm
end
function ZomboidSandbox:set_ZombieLore_ZombiesDragDown(v)
    self.settings.ZombieLore.ZombiesDragDown = v
end

function ZomboidSandbox:get_ZombieLore_ZombiesDragDown()
    return self.settings.ZombieLore.ZombiesDragDown
end
function ZomboidSandbox:set_ZombieLore_ZombiesFenceLunge(v)
    self.settings.ZombieLore.ZombiesFenceLunge = v
end

function ZomboidSandbox:get_ZombieLore_ZombiesFenceLunge()
    return self.settings.ZombieLore.ZombiesFenceLunge
end
function ZomboidSandbox:set_ZombieLore_DisableFakeDead(v)
    self.settings.ZombieLore.DisableFakeDead = v
end

function ZomboidSandbox:get_ZombieLore_DisableFakeDead()
    return self.settings.ZombieLore.DisableFakeDead
end

function ZomboidSandbox:set_Zombies(game_value)
    self.settings.Zombies = game_value
end

function ZomboidSandbox:get_Zombies()
    return self.settings.Zombies
end

function ZomboidSandbox:set_Distribution(game_value)
    self.settings.Distribution = game_value
end

function ZomboidSandbox:get_Distribution()
    return self.settings.Distribution
end

function ZomboidSandbox:set_DayLength(game_value)
    self.settings.DayLength = game_value
end

function ZomboidSandbox:get_DayLength()
    return self.settings.DayLength
end

function ZomboidSandbox:set_StartYear(game_value)
    self.settings.StartYear = game_value
end

function ZomboidSandbox:get_StartYear()
    return self.settings.StartYear
end

function ZomboidSandbox:set_StartMonth(game_value)
    self.settings.StartMonth = game_value
end

function ZomboidSandbox:get_StartMonth()
    return self.settings.StartMonth
end

function ZomboidSandbox:set_StartDay(game_value)
    self.settings.StartDay = game_value
end

function ZomboidSandbox:get_StartDay()
    return self.settings.StartDay
end

function ZomboidSandbox:set_StartTime(game_value)
    self.settings.StartTime = game_value
end

function ZomboidSandbox:get_StartTime()
    return self.settings.StartTime
end

function ZomboidSandbox:set_WaterShut(game_value)
    self.settings.WaterShut = game_value
end

function ZomboidSandbox:get_WaterShut()
    return self.settings.WaterShut
end

function ZomboidSandbox:set_ElecShut(game_value)
    self.settings.ElecShut = game_value
end

function ZomboidSandbox:get_ElecShut()
    return self.settings.ElecShut
end

function ZomboidSandbox:set_WaterShutModifier(game_value)
    self.settings.WaterShutModifier = game_value
end

function ZomboidSandbox:get_WaterShutModifier()
    return self.settings.WaterShutModifier
end

function ZomboidSandbox:set_ElecShutModifier(game_value)
    self.settings.ElecShutModifier = game_value
end

function ZomboidSandbox:get_ElecShutModifier()
    return self.settings.ElecShutModifier
end

function ZomboidSandbox:set_FoodLoot(game_value)
    self.settings.FoodLoot = game_value
end

function ZomboidSandbox:get_FoodLoot()
    return self.settings.FoodLoot
end

function ZomboidSandbox:set_CannedFoodLoot(game_value)
    self.settings.CannedFoodLoot = game_value
end

function ZomboidSandbox:get_CannedFoodLoot()
    return self.settings.CannedFoodLoot
end

function ZomboidSandbox:set_LiteratureLoot(game_value)
    self.settings.LiteratureLoot = game_value
end

function ZomboidSandbox:get_LiteratureLoot()
    return self.settings.LiteratureLoot
end

function ZomboidSandbox:set_SurvivalGearsLoot(game_value)
    self.settings.SurvivalGearsLoot = game_value
end

function ZomboidSandbox:get_SurvivalGearsLoot()
    return self.settings.SurvivalGearsLoot
end

function ZomboidSandbox:set_MedicalLoot(game_value)
    self.settings.MedicalLoot = game_value
end

function ZomboidSandbox:get_MedicalLoot()
    return self.settings.MedicalLoot
end

function ZomboidSandbox:set_WeaponLoot(game_value)
    self.settings.WeaponLoot = game_value
end

function ZomboidSandbox:get_WeaponLoot()
    return self.settings.WeaponLoot
end

function ZomboidSandbox:set_RangedWeaponLoot(game_value)
    self.settings.RangedWeaponLoot = game_value
end

function ZomboidSandbox:get_RangedWeaponLoot()
    return self.settings.RangedWeaponLoot
end

function ZomboidSandbox:set_AmmoLoot(game_value)
    self.settings.AmmoLoot = game_value
end

function ZomboidSandbox:get_AmmoLoot()
    return self.settings.AmmoLoot
end

function ZomboidSandbox:set_MechanicsLoot(game_value)
    self.settings.MechanicsLoot = game_value
end

function ZomboidSandbox:get_MechanicsLoot()
    return self.settings.MechanicsLoot
end

function ZomboidSandbox:set_OtherLoot(game_value)
    self.settings.OtherLoot = game_value
end

function ZomboidSandbox:get_OtherLoot()
    return self.settings.OtherLoot
end

function ZomboidSandbox:set_Temperature(game_value)
    self.settings.Temperature = game_value
end

function ZomboidSandbox:get_Temperature()
    return self.settings.Temperature
end

function ZomboidSandbox:set_Rain(game_value)
    self.settings.Rain = game_value
end

function ZomboidSandbox:get_Rain()
    return self.settings.Rain
end

function ZomboidSandbox:set_ErosionSpeed(game_value)
    self.settings.ErosionSpeed = game_value
end

function ZomboidSandbox:get_ErosionSpeed()
    return self.settings.ErosionSpeed
end

function ZomboidSandbox:set_ErosionDays(game_value)
    self.settings.ErosionDays = game_value
end

function ZomboidSandbox:get_ErosionDays()
    return self.settings.ErosionDays
end

function ZomboidSandbox:set_XpMultiplier(game_value)
    self.settings.XpMultiplier = game_value
end

function ZomboidSandbox:get_XpMultiplier()
    return self.settings.XpMultiplier
end

function ZomboidSandbox:set_XpMultiplierAffectsPassive(game_value)
    self.settings.XpMultiplierAffectsPassive = game_value
end

function ZomboidSandbox:get_XpMultiplierAffectsPassive()
    return self.settings.XpMultiplierAffectsPassive
end

function ZomboidSandbox:set_ZombieAttractionMultiplier(game_value)
    self.settings.ZombieAttractionMultiplier = game_value
end

function ZomboidSandbox:get_ZombieAttractionMultiplier()
    return self.settings.ZombieAttractionMultiplier
end

function ZomboidSandbox:set_VehicleEasyUse(game_value)
    self.settings.VehicleEasyUse = game_value
end

function ZomboidSandbox:get_VehicleEasyUse()
    return self.settings.VehicleEasyUse
end

function ZomboidSandbox:set_Farming(game_value)
    self.settings.Farming = game_value
end

function ZomboidSandbox:get_Farming()
    return self.settings.Farming
end

function ZomboidSandbox:set_CompostTime(game_value)
    self.settings.CompostTime = game_value
end

function ZomboidSandbox:get_CompostTime()
    return self.settings.CompostTime
end

function ZomboidSandbox:set_StatsDecrease(game_value)
    self.settings.StatsDecrease = game_value
end

function ZomboidSandbox:get_StatsDecrease()
    return self.settings.StatsDecrease
end

function ZomboidSandbox:set_NatureAbundance(game_value)
    self.settings.NatureAbundance = game_value
end

function ZomboidSandbox:get_NatureAbundance()
    return self.settings.NatureAbundance
end

function ZomboidSandbox:set_Alarm(game_value)
    self.settings.Alarm = game_value
end

function ZomboidSandbox:get_Alarm()
    return self.settings.Alarm
end

function ZomboidSandbox:set_LockedHouses(game_value)
    self.settings.LockedHouses = game_value
end

function ZomboidSandbox:get_LockedHouses()
    return self.settings.LockedHouses
end

function ZomboidSandbox:set_StarterKit(game_value)
    self.settings.StarterKit = game_value
end

function ZomboidSandbox:get_StarterKit()
    return self.settings.StarterKit
end

function ZomboidSandbox:set_Nutrition(game_value)
    self.settings.Nutrition = game_value
end

function ZomboidSandbox:get_Nutrition()
    return self.settings.Nutrition
end

function ZomboidSandbox:set_FoodRotSpeed(game_value)
    self.settings.FoodRotSpeed = game_value
end

function ZomboidSandbox:get_FoodRotSpeed()
    return self.settings.FoodRotSpeed
end

function ZomboidSandbox:set_FridgeFactor(game_value)
    self.settings.FridgeFactor = game_value
end

function ZomboidSandbox:get_FridgeFactor()
    return self.settings.FridgeFactor
end

function ZomboidSandbox:set_LootRespawn(game_value)
    self.settings.LootRespawn = game_value
end

function ZomboidSandbox:get_LootRespawn()
    return self.settings.LootRespawn
end

function ZomboidSandbox:set_SeenHoursPreventLootRespawn(game_value)
    self.settings.SeenHoursPreventLootRespawn = game_value
end

function ZomboidSandbox:get_SeenHoursPreventLootRespawn()
    return self.settings.SeenHoursPreventLootRespawn
end

function ZomboidSandbox:set_WorldItemRemovalList(game_value)
    self.settings.WorldItemRemovalList = game_value
end

function ZomboidSandbox:get_WorldItemRemovalList()
    return self.settings.WorldItemRemovalList
end

function ZomboidSandbox:set_HoursForWorldItemRemoval(game_value)
    self.settings.HoursForWorldItemRemoval = game_value
end

function ZomboidSandbox:get_HoursForWorldItemRemoval()
    return self.settings.HoursForWorldItemRemoval
end

function ZomboidSandbox:set_ItemRemovalListBlacklistToggle(game_value)
    self.settings.ItemRemovalListBlacklistToggle = game_value
end

function ZomboidSandbox:get_ItemRemovalListBlacklistToggle()
    return self.settings.ItemRemovalListBlacklistToggle
end

function ZomboidSandbox:set_TimeSinceApo(game_value)
    self.settings.TimeSinceApo = game_value
end

function ZomboidSandbox:get_TimeSinceApo()
    return self.settings.TimeSinceApo
end

function ZomboidSandbox:set_PlantResilience(game_value)
    self.settings.PlantResilience = game_value
end

function ZomboidSandbox:get_PlantResilience()
    return self.settings.PlantResilience
end

function ZomboidSandbox:set_PlantAbundance(game_value)
    self.settings.PlantAbundance = game_value
end

function ZomboidSandbox:get_PlantAbundance()
    return self.settings.PlantAbundance
end

function ZomboidSandbox:set_EndRegen(game_value)
    self.settings.EndRegen = game_value
end

function ZomboidSandbox:get_EndRegen()
    return self.settings.EndRegen
end

function ZomboidSandbox:set_Helicopter(game_value)
    self.settings.Helicopter = game_value
end

function ZomboidSandbox:get_Helicopter()
    return self.settings.Helicopter
end

function ZomboidSandbox:set_MetaEvent(game_value)
    self.settings.MetaEvent = game_value
end

function ZomboidSandbox:get_MetaEvent()
    return self.settings.MetaEvent
end

function ZomboidSandbox:set_SleepingEvent(game_value)
    self.settings.SleepingEvent = game_value
end

function ZomboidSandbox:get_SleepingEvent()
    return self.settings.SleepingEvent
end

function ZomboidSandbox:set_GeneratorSpawning(game_value)
    self.settings.GeneratorSpawning = game_value
end

function ZomboidSandbox:get_GeneratorSpawning()
    return self.settings.GeneratorSpawning
end

function ZomboidSandbox:set_GeneratorFuelConsumption(game_value)
    self.settings.GeneratorFuelConsumption = game_value
end

function ZomboidSandbox:get_GeneratorFuelConsumption()
    return self.settings.GeneratorFuelConsumption
end

function ZomboidSandbox:set_SurvivorHouseChance(game_value)
    self.settings.SurvivorHouseChance = game_value
end

function ZomboidSandbox:get_SurvivorHouseChance()
    return self.settings.SurvivorHouseChance
end

function ZomboidSandbox:set_VehicleStoryChance(game_value)
    self.settings.VehicleStoryChance = game_value
end

function ZomboidSandbox:get_VehicleStoryChance()
    return self.settings.VehicleStoryChance
end

function ZomboidSandbox:set_ZoneStoryChance(game_value)
    self.settings.ZoneStoryChance = game_value
end

function ZomboidSandbox:get_ZoneStoryChance()
    return self.settings.ZoneStoryChance
end

function ZomboidSandbox:set_AnnotatedMapChance(game_value)
    self.settings.AnnotatedMapChance = game_value
end

function ZomboidSandbox:get_AnnotatedMapChance()
    return self.settings.AnnotatedMapChance
end

function ZomboidSandbox:set_CharacterFreePoints(game_value)
    self.settings.CharacterFreePoints = game_value
end

function ZomboidSandbox:get_CharacterFreePoints()
    return self.settings.CharacterFreePoints
end

function ZomboidSandbox:set_ConstructionBonusPoints(game_value)
    self.settings.ConstructionBonusPoints = game_value
end

function ZomboidSandbox:get_ConstructionBonusPoints()
    return self.settings.ConstructionBonusPoints
end

function ZomboidSandbox:set_NightDarkness(game_value)
    self.settings.NightDarkness = game_value
end

function ZomboidSandbox:get_NightDarkness()
    return self.settings.NightDarkness
end

function ZomboidSandbox:set_NightLength(game_value)
    self.settings.NightLength = game_value
end

function ZomboidSandbox:get_NightLength()
    return self.settings.NightLength
end

function ZomboidSandbox:set_InjurySeverity(game_value)
    self.settings.InjurySeverity = game_value
end

function ZomboidSandbox:get_InjurySeverity()
    return self.settings.InjurySeverity
end

function ZomboidSandbox:set_BoneFracture(game_value)
    self.settings.BoneFracture = game_value
end

function ZomboidSandbox:get_BoneFracture()
    return self.settings.BoneFracture
end

function ZomboidSandbox:set_HoursForCorpseRemoval(game_value)
    self.settings.HoursForCorpseRemoval = game_value
end

function ZomboidSandbox:get_HoursForCorpseRemoval()
    return self.settings.HoursForCorpseRemoval
end

function ZomboidSandbox:set_DecayingCorpseHealthImpact(game_value)
    self.settings.DecayingCorpseHealthImpact = game_value
end

function ZomboidSandbox:get_DecayingCorpseHealthImpact()
    return self.settings.DecayingCorpseHealthImpact
end

function ZomboidSandbox:set_BloodLevel(game_value)
    self.settings.BloodLevel = game_value
end

function ZomboidSandbox:get_BloodLevel()
    return self.settings.BloodLevel
end

function ZomboidSandbox:set_ClothingDegradation(game_value)
    self.settings.ClothingDegradation = game_value
end

function ZomboidSandbox:get_ClothingDegradation()
    return self.settings.ClothingDegradation
end

function ZomboidSandbox:set_FireSpread(game_value)
    self.settings.FireSpread = game_value
end

function ZomboidSandbox:get_FireSpread()
    return self.settings.FireSpread
end

function ZomboidSandbox:set_DaysForRottenFoodRemoval(game_value)
    self.settings.DaysForRottenFoodRemoval = game_value
end

function ZomboidSandbox:get_DaysForRottenFoodRemoval()
    return self.settings.DaysForRottenFoodRemoval
end

function ZomboidSandbox:set_AllowExteriorGenerator(game_value)
    self.settings.AllowExteriorGenerator = game_value
end

function ZomboidSandbox:get_AllowExteriorGenerator()
    return self.settings.AllowExteriorGenerator
end

function ZomboidSandbox:set_MaxFogIntensity(game_value)
    self.settings.MaxFogIntensity = game_value
end

function ZomboidSandbox:get_MaxFogIntensity()
    return self.settings.MaxFogIntensity
end

function ZomboidSandbox:set_MaxRainFxIntensity(game_value)
    self.settings.MaxRainFxIntensity = game_value
end

function ZomboidSandbox:get_MaxRainFxIntensity()
    return self.settings.MaxRainFxIntensity
end

function ZomboidSandbox:set_EnableSnowOnGround(game_value)
    self.settings.EnableSnowOnGround = game_value
end

function ZomboidSandbox:get_EnableSnowOnGround()
    return self.settings.EnableSnowOnGround
end

function ZomboidSandbox:set_MultiHitZombies(game_value)
    self.settings.MultiHitZombies = game_value
end

function ZomboidSandbox:get_MultiHitZombies()
    return self.settings.MultiHitZombies
end

function ZomboidSandbox:set_RearVulnerability(game_value)
    self.settings.RearVulnerability = game_value
end

function ZomboidSandbox:get_RearVulnerability()
    return self.settings.RearVulnerability
end

function ZomboidSandbox:set_AttackBlockMovements(game_value)
    self.settings.AttackBlockMovements = game_value
end

function ZomboidSandbox:get_AttackBlockMovements()
    return self.settings.AttackBlockMovements
end

function ZomboidSandbox:set_AllClothesUnlocked(game_value)
    self.settings.AllClothesUnlocked = game_value
end

function ZomboidSandbox:get_AllClothesUnlocked()
    return self.settings.AllClothesUnlocked
end

function ZomboidSandbox:set_EnableTaintedWaterText(game_value)
    self.settings.EnableTaintedWaterText = game_value
end

function ZomboidSandbox:get_EnableTaintedWaterText()
    return self.settings.EnableTaintedWaterText
end

function ZomboidSandbox:set_CarSpawnRate(game_value)
    self.settings.CarSpawnRate = game_value
end

function ZomboidSandbox:get_CarSpawnRate()
    return self.settings.CarSpawnRate
end

function ZomboidSandbox:set_ChanceHasGas(game_value)
    self.settings.ChanceHasGas = game_value
end

function ZomboidSandbox:get_ChanceHasGas()
    return self.settings.ChanceHasGas
end

function ZomboidSandbox:set_InitialGas(game_value)
    self.settings.InitialGas = game_value
end

function ZomboidSandbox:get_InitialGas()
    return self.settings.InitialGas
end

function ZomboidSandbox:set_FuelStationGas(game_value)
    self.settings.FuelStationGas = game_value
end

function ZomboidSandbox:get_FuelStationGas()
    return self.settings.FuelStationGas
end

function ZomboidSandbox:set_CarGasConsumption(game_value)
    self.settings.CarGasConsumption = game_value
end

function ZomboidSandbox:get_CarGasConsumption()
    return self.settings.CarGasConsumption
end

function ZomboidSandbox:set_LockedCar(game_value)
    self.settings.LockedCar = game_value
end

function ZomboidSandbox:get_LockedCar()
    return self.settings.LockedCar
end

function ZomboidSandbox:set_CarGeneralCondition(game_value)
    self.settings.CarGeneralCondition = game_value
end

function ZomboidSandbox:get_CarGeneralCondition()
    return self.settings.CarGeneralCondition
end

function ZomboidSandbox:set_CarDamageOnImpact(game_value)
    self.settings.CarDamageOnImpact = game_value
end

function ZomboidSandbox:get_CarDamageOnImpact()
    return self.settings.CarDamageOnImpact
end

function ZomboidSandbox:set_DamageToPlayerFromHitByACar(game_value)
    self.settings.DamageToPlayerFromHitByACar = game_value
end

function ZomboidSandbox:get_DamageToPlayerFromHitByACar()
    return self.settings.DamageToPlayerFromHitByACar
end

function ZomboidSandbox:set_TrafficJam(game_value)
    self.settings.TrafficJam = game_value
end

function ZomboidSandbox:get_TrafficJam()
    return self.settings.TrafficJam
end

function ZomboidSandbox:set_CarAlarm(game_value)
    self.settings.CarAlarm = game_value
end

function ZomboidSandbox:get_CarAlarm()
    return self.settings.CarAlarm
end

function ZomboidSandbox:set_PlayerDamageFromCrash(game_value)
    self.settings.PlayerDamageFromCrash = game_value
end

function ZomboidSandbox:get_PlayerDamageFromCrash()
    return self.settings.PlayerDamageFromCrash
end

function ZomboidSandbox:set_SirenShutoffHours(game_value)
    self.settings.SirenShutoffHours = game_value
end

function ZomboidSandbox:get_SirenShutoffHours()
    return self.settings.SirenShutoffHours
end

function ZomboidSandbox:set_RecentlySurvivorVehicles(game_value)
    self.settings.RecentlySurvivorVehicles = game_value
end

function ZomboidSandbox:get_RecentlySurvivorVehicles()
    return self.settings.RecentlySurvivorVehicles
end

function ZomboidSandbox:set_EnableVehicles(game_value)
    self.settings.EnableVehicles = game_value
end

function ZomboidSandbox:get_EnableVehicles()
    return self.settings.EnableVehicles
end

function ZomboidSandbox:set_EnablePoisoning(game_value)
    self.settings.EnablePoisoning = game_value
end

function ZomboidSandbox:get_EnablePoisoning()
    return self.settings.EnablePoisoning
end

function ZomboidSandbox:set_MaggotSpawn(game_value)
    self.settings.MaggotSpawn = game_value
end

function ZomboidSandbox:get_MaggotSpawn()
    return self.settings.MaggotSpawn
end

function ZomboidSandbox:set_LightBulbLifespan(game_value)
    self.settings.LightBulbLifespan = game_value
end

function ZomboidSandbox:get_LightBulbLifespan()
    return self.settings.LightBulbLifespan
end

function ZomboidSandbox:set_VERSION(v)
    self.version = v
end

function ZomboidSandbox:new(o)
    o = o or {}
    o.__index = self.__index
    setmetatable(o, self)
    return o
end

ZomboidSandboxVarsInterface = {
    display_order = {
        'LoadFile',
        'Reload',
        'VERSION',
        'Zombies',
        'Distribution',
        'DayLength',
        'StartYear',
        'StartMonth',
        'StartDay',
        'StartTime',
        'WaterShut',
        'ElecShut',
        'WaterShutModifier',
        'ElecShutModifier',
        'FoodLoot',
        'CannedFoodLoot',
        'LiteratureLoot',
        'SurvivalGearsLoot',
        'MedicalLoot',
        'WeaponLoot',
        'RangedWeaponLoot',
        'AmmoLoot',
        'MechanicsLoot',
        'OtherLoot',
        'Temperature',
        'Rain',
        'ErosionSpeed',
        'ErosionDays',
        'XpMultiplier',
        'XpMultiplierAffectsPassive',
        'ZombieAttractionMultiplier',
        'VehicleEasyUse',
        'Farming',
        'CompostTime',
        'StatsDecrease',
        'NatureAbundance',
        'Alarm',
        'LockedHouses',
        'StarterKit',
        'Nutrition',
        'FoodRotSpeed',
        'FridgeFactor',
        'LootRespawn',
        'SeenHoursPreventLootRespawn',
        'WorldItemRemovalList',
        'HoursForWorldItemRemoval',
        'ItemRemovalListBlacklistToggle',
        'TimeSinceApo',
        'PlantResilience',
        'PlantAbundance',
        'EndRegen',
        'Helicopter',
        'MetaEvent',
        'SleepingEvent',
        'GeneratorSpawning',
        'GeneratorFuelConsumption',
        'SurvivorHouseChance',
        'VehicleStoryChance',
        'ZoneStoryChance',
        'AnnotatedMapChance',
        'CharacterFreePoints',
        'ConstructionBonusPoints',
        'NightDarkness',
        'NightLength',
        'InjurySeverity',
        'BoneFracture',
        'HoursForCorpseRemoval',
        'DecayingCorpseHealthImpact',
        'BloodLevel',
        'ClothingDegradation',
        'FireSpread',
        'DaysForRottenFoodRemoval',
        'AllowExteriorGenerator',
        'MaxFogIntensity',
        'MaxRainFxIntensity',
        'EnableSnowOnGround',
        'MultiHitZombies',
        'RearVulnerability',
        'AttackBlockMovements',
        'AllClothesUnlocked',
        'EnableTaintedWaterText',
        'CarSpawnRate',
        'ChanceHasGas',
        'InitialGas',
        'FuelStationGas',
        'CarGasConsumption',
        'LockedCar',
        'CarGeneralCondition',
        'CarDamageOnImpact',
        'DamageToPlayerFromHitByACar',
        'TrafficJam',
        'CarAlarm',
        'PlayerDamageFromCrash',
        'SirenShutoffHours',
        'RecentlySurvivorVehicles',
        'EnableVehicles',
        'EnablePoisoning',
        'MaggotSpawn',
        'LightBulbLifespan',
        'Map_AllowMiniMap',
        'Map_AllowWorldMap',
        'Map_AllKnown',
        'ZombieLore_Speed',
        'ZombieLore_Strength',
        'ZombieLore_Toughness',
        'ZombieLore_Transmission',
        'ZombieLore_Mortality',
        'ZombieLore_Reanimate',
        'ZombieLore_Cognition',
        'ZombieLore_CrawlUnderVehicle',
        'ZombieLore_Memory',
        'ZombieLore_Sight',
        'ZombieLore_Hearing',
        'ZombieLore_ThumpNoChasing',
        'ZombieLore_ThumpOnConstruction',
        'ZombieLore_ActiveOnly',
        'ZombieLore_TriggerHouseAlarm',
        'ZombieLore_ZombiesDragDown',
        'ZombieLore_ZombiesFenceLunge',
        'ZombieLore_DisableFakeDead',
        'ZombieConfig_PopulationMultiplier',
        'ZombieConfig_PopulationStartMultiplier',
        'ZombieConfig_PopulationPeakMultiplier',
        'ZombieConfig_PopulationPeakDay',
        'ZombieConfig_RespawnHours',
        'ZombieConfig_RespawnUnseenHours',
        'ZombieConfig_RespawnMultiplier',
        'ZombieConfig_RedistributeHours',
        'ZombieConfig_FollowSoundDistance',
        'ZombieConfig_RallyGroupSize',
        'ZombieConfig_RallyTravelDistance',
        'ZombieConfig_RallyGroupSeparation',
        'ZombieConfig_RallyGroupRadius'
    },
    instance = ZomboidSandbox:new(),
    load_file_handler = {
        value = '',
        last_loaded = '',
        load_file = function(selected_file, reload)
            local _this = ZomboidSandboxVarsInterface.load_file_handler
            reload = reload or false
            if selected_file == _this.last_loaded and not reload then
                return false
            end
            if file_exists(selected_file) then
                local data_file = io.open(selected_file, 'r')
                if not data_file then
                    return false
                end
                local contents = data_file:read("*all")
                data_file:close()
                _this.value = selected_file
                _this.last_loaded = ''
                local f, err = load(contents)
                if f then
                    local ok = pcall(f)
                    if ok then
                        for k, v in pairs(SandboxVars) do
                            ZomboidSandbox.settings[k] = v
                        end
                        _this.last_loaded = selected_file
                    end
                end
            else
                _this.value = ''
                return false
            end
            return true
        end,
    },
    schema = {
        LoadFile =
        {
            description = 'Load Sandbox File',
            default = '',
            type = FileBrowse,
            setter = function(selected_file)
                if not file_exists(selected_file) then
                    return
                end
                local old_sandbox = SandboxVars
                SandboxVars = {}
                local loaded = 
                    ZomboidSandboxVarsInterface
                    .load_file_handler
                    .load_file(selected_file, false)
                if not loaded then
                    SandboxVars = old_sandbox
                end
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.load_file_handler.value
            end 
        },
        Reload =
        {
            description = 'Reload Sandbox File',
            type = Button,
            action = function()
                local old_sandbox = SandboxVars
                SandboxVars = {}
                local loaded = 
                    ZomboidSandboxVarsInterface
                    .load_file_handler
                    .load_file(
                        ZomboidSandboxVarsInterface.load_file_handler.last_loaded,
                        true
                    )
                if not loaded then
                    SandboxVars = old_sandbox
                end
            end,
            getter = function() return 'Reload Sandbox File' end
        },
        VERSION =
        {
            description = 'VERSION',
            default = 5,
            type = IntegerRange,
            minimum = 5,
            maximum = 5,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_VERSION(v)
            end,
            getter = function() return 5 end
        },
        Zombies =
        {
            description = 'Zombie Population',
            default = 'Normal',
            type = Enum,
            values = {'Insane', 'Very High', 'High', 'Normal', 'Low'},
            setter = function(v)
                local values = ZomboidSandboxVarsInterface.schema.Zombies.values
                local set_from_string = false
                for i = 1, #values do
                    if v == values[i] then 
                        set_from_string = true
                        ZomboidSandboxVarsInterface.instance:set_Zombies(i)
                    end
                end
                if not set_from_string then
                    local lua_index = v + 1
                    ZomboidSandboxVarsInterface.instance:set_Zombies(lua_index)
                end
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.Zombies.values
                return values[ZomboidSandboxVarsInterface.instance:get_Zombies()]
            end
        },
        Distribution =
        {
            description = 'Distribution',
            default = 'Urban Focused',
            type = Enum,
            values = {'Urban Focused'},
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_Distribution(v + 1)
            end,
            getter = function() return 'Urban Focused' end
        },
        DayLength =
        {
            description = 'Day Length',
            default = '1 Hour',
            type = Enum,
            values = {
                '15 Minutes',
                '30 Minutes',
                '1 Hour',
                '2 Hours',
                '3 Hours',
                '4 Hours',
                '5 Hours',
                '6 Hours',
                '7 Hours',
                '8 Hours',
                '9 Hours',
                '10 Hours',
                '11 Hours',
                '12 Hours',
                '13 Hours',
                '14 Hours',
                '15 Hours',
                '16 Hours',
                '17 Hours',
                '18 Hours',
                '19 Hours',
                '20 Hours',
                '21 Hours',
                '22 Hours',
                '23 Hours',
            },
            setter = function(c_index)
                local lua_index = c_index + 1
                ZomboidSandboxVarsInterface.instance:set_DayLength(lua_index)
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.DayLength.values
                return values[ZomboidSandboxVarsInterface.instance:get_DayLength()]
            end
        },
        StartYear =
        {
            description = 'Start Year',
            default = 1,
            type = Integer,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_StartYear(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_StartYear()
            end
        },
        StartMonth =
        {
            description = 'Start Month',
            default = 'July',
            type = Enum,
            values = {
                'January',
                'February',
                'March',
                'April',
                'May',
                'June',
                'July',
                'August',
                'September',
                'October',
                'November',
                'December'
            },
            setter = function(c_index)
                ZomboidSandboxVarsInterface.instance:set_StartMonth(c_index + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.StartMonth.values
                return values[ZomboidSandboxVarsInterface.instance:get_StartMonth()]
            end
        },
        StartDay =
        {
            description = 'Start Day',
            default = 9,
            type = Integer,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_StartDay(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_StartDay()
            end
        },
        StartTime =
        {
            description = 'Start Time',
            default = '9 AM',
            type = Enum,
            values = {'7 AM', '9 AM', '12 PM', '2 PM', '5 PM', '9 PM', '12 AM', '2 AM'},
            setter = function(c_index)
                local lua_index = c_index + 1
                ZomboidSandboxVarsInterface.instance:set_StartTime(lua_index)
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.StartTime.values
                return values[ZomboidSandboxVarsInterface.instance:get_StartTime()]
            end
        },
        WaterShut =
        {
            description = 'WaterShut',
            default = '0-30 Days',
            type = Enum,
            values = {
                'Instant',
                '0-30 Days',
                '0-2 Months',
                '0-6 Months',
                '0-1 Year',
                '0-5 Years',
                '2-6 Months'
            },
            setter = function(c_index)
                ZomboidSandboxVarsInterface.instance:set_WaterShut(c_index + 1)
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.WaterShut.values
                return values[ZomboidSandboxVarsInterface.instance:get_WaterShut()]
            end
        },
        ElecShut =
        {
            description = 'ElecShut',
            default = '0-30 Days',
            type = Enum,
            values = {
                'Instant',
                '0-30 Days',
                '0-2 Months',
                '0-6 Months',
                '0-1 Year',
                '0-5 Years',
                '2-6 Months'
            },
            setter = function(c_index)
                ZomboidSandboxVarsInterface.instance:set_ElecShut(c_index + 1)
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.ElecShut.values
                return values[ZomboidSandboxVarsInterface.instance:get_ElecShut()]
            end
        },
        WaterShutModifier = 
        {
            description = 'WaterShutModifier',
            default = 14,
            type = IntegerRange,
            minimum = -1,
            maximum = 2147483647,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_WaterShutModifier(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_WaterShutModifier()
            end
        },
        ElecShutModifier = 
        {
            description = 'ElecShutModifier',
            default = 4,
            type = IntegerRange,
            minimum = -1,
            maximum = 2147483647,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ElecShutModifier(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_ElecShutModifier()
            end
        },
        FoodLoot =
        {
            description = 'FoodLoot',
            default = 'Rare',
            type = Enum,
            values = {
                'None (not recommended)',
                'Insanely Rare',
                'Extremely Rare',
                'Rare',
                'Normal',
                'Common'
            },
            setter = function(c_index)
                local lua_index = c_index + 1
                ZomboidSandboxVarsInterface.instance:set_FoodLoot(lua_index)
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.FoodLoot.values
                return values[ZomboidSandboxVarsInterface.instance:get_FoodLoot()]
            end
        },
        CannedFoodLoot =
        {
            description = 'CannedFoodLoot',
            default = 'Rare',
            type = Enum,
            values = {
                'None (not recommended)',
                'Insanely Rare',
                'Extremely Rare',
                'Rare',
                'Normal',
                'Common'
            },
            setter = function(c_index)
                local lua_index = c_index + 1
                ZomboidSandboxVarsInterface.instance:set_CannedFoodLoot(lua_index)
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.CannedFoodLoot.values
                return values[ZomboidSandboxVarsInterface.instance:get_CannedFoodLoot()]
            end
        },
        LiteratureLoot =
        {
            description = 'LiteratureLoot',
            type = Enum,
            default = 'Rare',
            values = {
                'None (not recommended)',
                'Insanely Rare',
                'Extremely Rare',
                'Rare',
                'Normal',
                'Common'
            },
            setter = function(c_index)
                local lua_index = c_index + 1
                ZomboidSandboxVarsInterface.instance:set_LiteratureLoot(lua_index)
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.LiteratureLoot.values
                return values[ZomboidSandboxVarsInterface.instance:get_LiteratureLoot()]
            end
        },
        SurvivalGearsLoot =
        {
            description = 'SurvivalGearsLoot',
            type = Enum,
            default = 'Rare',
            values = {
                'None (not recommended)',
                'Insanely Rare',
                'Extremely Rare',
                'Rare',
                'Normal',
                'Common'
            },
            setter = function(c_index)
                local lua_index = c_index + 1
                ZomboidSandboxVarsInterface.instance:set_SurvivalGearsLoot(lua_index)
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.SurvivalGearsLoot.values
                return values[ZomboidSandboxVarsInterface.instance:get_SurvivalGearsLoot()]
            end
        },
        MedicalLoot =
        {
            description = 'MedicalLoot',
            type = Enum,
            default = 'Rare',
            values = {
                'None (not recommended)',
                'Insanely Rare',
                'Extremely Rare',
                'Rare',
                'Normal',
                'Common'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_MedicalLoot(v + 1)
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.MedicalLoot.values
                return values[ZomboidSandboxVarsInterface.instance:get_MedicalLoot()]
            end
        },
        WeaponLoot =
        {
            description = 'WeaponLoot',
            type = Enum,
            default = 'Rare',
            values = {
                'None (not recommended)',
                'Insanely Rare',
                'Extremely Rare',
                'Rare',
                'Normal',
                'Common'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_WeaponLoot(v + 1)
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.WeaponLoot.values
                return values[ZomboidSandboxVarsInterface.instance:get_WeaponLoot()]
            end
        },
        RangedWeaponLoot =
        {
            description = 'RangedWeaponLoot',
            type = Enum,
            default = 'Rare',
            values = {
                'None (not recommended)',
                'Insanely Rare',
                'Extremely Rare',
                'Rare',
                'Normal',
                'Common'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_RangedWeaponLoot(v + 1)
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.RangedWeaponLoot.values
                return values[ZomboidSandboxVarsInterface.instance:get_RangedWeaponLoot()]
            end
        },
        AmmoLoot =
        {
            description = 'AmmoLoot',
            type = Enum,
            default = 'Rare',
            values = {
                'None (not recommended)',
                'Insanely Rare',
                'Extremely Rare',
                'Rare',
                'Normal',
                'Common'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_AmmoLoot(v + 1)
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.AmmoLoot.values
                return values[ZomboidSandboxVarsInterface.instance:get_AmmoLoot()]
            end
        },
        MechanicsLoot =
        {
            description = 'MechanicsLoot',
            type = Enum,
            default = 'Rare',
            values = {
                'None (not recommended)',
                'Insanely Rare',
                'Extremely Rare',
                'Rare',
                'Normal',
                'Common'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_MechanicsLoot(v + 1)
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.MechanicsLoot.values
                return values[ZomboidSandboxVarsInterface.instance:get_MechanicsLoot()]
            end
        },
        OtherLoot =
        {
            description = 'OtherLoot',
            type = Enum,
            default = 'Rare',
            values = {
                'None (not recommended)',
                'Insanely Rare',
                'Extremely Rare',
                'Rare',
                'Normal',
                'Common'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_OtherLoot(v + 1)
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.OtherLoot.values
                return values[ZomboidSandboxVarsInterface.instance:get_OtherLoot()]
            end
        },
        Temperature =
        {
            description = 'Temperature',
            default = 'Normal',
            type = Enum,
            values = {
                'Very Cold',
                'Cold',
                'Normal',
                'Hot'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_Temperature(v + 1)
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.Temperature.values
                return values[ZomboidSandboxVarsInterface.instance:get_Temperature()]
            end
        },
        Rain =
        {
            description = 'Rain',
            default = 'Normal',
            type = Enum,
            values = {
                'Very Dry',
                'Dry',
                'Normal',
                'Rainy',
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_Rain(v + 1)
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.Rain.values
                return values[ZomboidSandboxVarsInterface.instance:get_Rain()]
            end
        },
        ErosionSpeed =
        {
            description = 'ErosionSpeed',
            default = 'Normal (100 Days)',
            type = Enum,
            values = {
                'Very Fast (20 Days)',
                'Fast (50 Days)',
                'Normal (100 Days)',
                'Slow (200 Days)'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ErosionSpeed(v + 1)
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.ErosionSpeed.values
                return values[ZomboidSandboxVarsInterface.instance:get_ErosionSpeed()]
            end
        },
        ErosionDays =
        {
            description = 'ErosionDays',
            default = 0,
            minimum = -1,
            maximum = 36500,
            type = IntegerRange,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ErosionDays(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_ErosionDays()
            end
        },
        XpMultiplier =
        {
            description = 'XpMultiplier',
            default = 1.0,
            type = FloatRange,
            minimum = 0.0,
            maximum = 1000.0,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_XpMultiplier(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_XpMultiplier()
            end
        },
        XpMultiplierAffectsPassive =
        {
            description = 'XpMultiplierAffectsPassive',
            default = false,
            type = Boolean,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_XpMultiplierAffectsPassive(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_XpMultiplierAffectsPassive()
            end
        },
        ZombieAttractionMultiplier =
        {
            description = 'ZombieAttractionMultiplier',
            default = 1.0,
            type = FloatRange,
            minimum = 0.0,
            maximum = 100.0,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieAttractionMultiplier(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_ZombieAttractionMultiplier()
            end
        },
        VehicleEasyUse =
        {
            description = 'VehicleEasyUse',
            default = false,
            type = Boolean,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_VehicleEasyUse(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_VehicleEasyUse()
            end
        },
        Farming =
        {
            description = 'Farming',
            default = 'Normal',
            type = Enum,
            values = {
                'Very Fast',
                'Fast',
                'Normal',
                'Slow '
            },
            setter = function(c_index)
                ZomboidSandboxVarsInterface.instance:set_Farming(c_index + 1)
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.Farming.values
                return values[ZomboidSandboxVarsInterface.instance:get_Farming()]
            end
        },
        -- TODO: Resume here
        CompostTime =
        {
            description = 'CompostTime',
            default = '2 Weeks',
            type = Enum,
            values = {
                '1 Week',
                '2 Weeks',
                '3 Weeks',
                '4 Weeks',
                '6 Weeks',
                '8 Weeks',
                '10 Weeks',
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_CompostTime(v + 1)
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.CompostTime.values
                return values[ZomboidSandboxVarsInterface.instance:get_CompostTime()]
            end
        },
        StatsDecrease =
        {
            description = 'StatsDecrease',
            default = 'Normal',
            type = Enum,
            values = {
            'Very Fast',
            'Fast',
            'Normal',
            'Slow'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_StatsDecrease(v + 1)
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.StatsDecrease.values
                return values[ZomboidSandboxVarsInterface.instance:get_StatsDecrease()]
            end
        },
        NatureAbundance =
        {
            description = 'NatureAbundance',
            default = 'Normal',
            type = Enum,
            values = {
                'Very Poor',
                'Poor',
                'Normal',
                'Abundant'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_NatureAbundance(v + 1)
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.NatureAbundance.values
                return values[ZomboidSandboxVarsInterface.instance:get_NatureAbundance()]
            end
        },
        Alarm =
        {
            description = 'Alarm',
            default = 'Sometimes',
            type = Enum,
            values = {
                'Never',
                'Extremely Rare',
                'Rare',
                'Sometimes',
                'Often'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_Alarm(v + 1)
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.Alarm.values
                return values[ZomboidSandboxVarsInterface.instance:get_Alarm()]
            end
        },
        LockedHouses =
        {
            description = 'LockedHouses',
            default = 'Very Often',
            type = Enum,
            values = {
                'Never',
                'Extremely Rare',
                'Rare',
                'Sometimes',
                'Often',
                'Very Often'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_LockedHouses(v + 1)
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.LockedHouses.values
                return values[ZomboidSandboxVarsInterface.instance:get_LockedHouses()]
            end
        },
        StarterKit =
        {
            description = 'StarterKit',
            default = false,
            type = Boolean,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_StarterKit(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_StarterKit()
            end
        },
        Nutrition =
        {
            description = 'Nutrition',
            default = true,
            type = Boolean,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_Nutrition(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_Nutrition()
            end
        },
        FoodRotSpeed =
        {
            description = 'FoodRotSpeed',
            default = 'Normal',
            type = Enum,
            values = {
                'Very Fast',
                'Fast',
                'Normal',
                'Slow'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_FoodRotSpeed(v + 1)
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.FoodRotSpeed.values
                return values[ZomboidSandboxVarsInterface.instance:get_FoodRotSpeed()]
            end
        },
        FridgeFactor =
        {
            description = 'FridgeFactor',
            default = 'Normal',
            type = Enum,
            values = {
                'Very Low',
                'Low',
                'Normal',
                'High'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_FridgeFactor(v + 1)
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.FridgeFactor.values
                return values[ZomboidSandboxVarsInterface.instance:get_FridgeFactor()]
            end
        },
        LootRespawn =
        {
            description = 'LootRespawn',
            default = 'None',
            type = Enum,
            values = {
                'None',
                'Every Day',
                'Every Week',
                'Every Month'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_LootRespawn(v + 1)
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.LootRespawn.values
                return values[ZomboidSandboxVarsInterface.instance:get_LootRespawn()]
            end
        },
        SeenHoursPreventLootRespawn =
        {
            description = 'SeenHoursPreventLootRespawn',
            default = 0,
            type = IntegerRange,
            minimum = 0,
            maximum = 2147483647,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_SeenHoursPreventLootRespawn(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_SeenHoursPreventLootRespawn()
            end
        },
        WorldItemRemovalList =
        {
            description = 'WorldItemRemovalList',
            default = 'Base.Hat,Base.Glasses,Base.Maggots',
            type = String,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_WorldItemRemovalList(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_WorldItemRemovalList()
            end
        },
        HoursForWorldItemRemoval =
        {
            description = 'HoursForWorldItemRemoval',
            default = 24.0,
            type = FloatRange,
            minimum = 0.0,
            maximum = 2147483647.0,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_HoursForWorldItemRemoval(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_HoursForWorldItemRemoval()
            end
        },
        ItemRemovalListBlacklistToggle =
        {
            description = 'ItemRemovalListBlacklistToggle',
            default = false,
            type = Boolean,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ItemRemovalListBlacklistToggle(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_ItemRemovalListBlacklistToggle()
            end
        },
        TimeSinceApo =
        {
            description = 'TimeSinceApo',
            default = 0,
            type = IntegerRange,
            minimum = 0,
            maximum = 11,
            setter = function(v)
                local translated_apo_from_ui = v + 1
                ZomboidSandboxVarsInterface.instance:set_TimeSinceApo(translated_apo_from_ui)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_TimeSinceApo()
            end
        },
        PlantResilience =
        {
            description = 'PlantResilience',
            default = 'Normal',
            type = Enum,
            values = {
                'Very High',
                'High',
                'Normal',
                'Low'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_PlantResilience(v + 1)
            end,
            getter = function()
                local values = ZomboidSandboxVarsInterface.schema.PlantResilience.values
                return values[ZomboidSandboxVarsInterface.instance:get_PlantResilience()]
            end
        },
        PlantAbundance =
        {
            description = 'PlantAbundance',
            default = 'Normal',
            type = Enum,
            values = {
                'Very Poor',
                'Poor',
                'Normal',
                'Abundant'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_PlantAbundance(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.PlantAbundance.values
                 return values[ZomboidSandboxVarsInterface.instance:get_PlantAbundance()]
            end
        },
        EndRegen =
        {
            description = 'EndRegen',
            default = 'Normal',
            type = Enum,
            values = {
                'Very Fast',
                'Fast',
                'Normal',
                'Slow',
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_EndRegen(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.EndRegen.values
                 return values[ZomboidSandboxVarsInterface.instance:get_EndRegen()]
            end
        },
        Helicopter =
        {
            description = 'Helicopter',
            default = 'Once',
            type = Enum,
            values = {
                'Never',
                'Once',
                'Sometimes'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_Helicopter(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.Helicopter.values
                 return values[ZomboidSandboxVarsInterface.instance:get_Helicopter()]
            end
        },
        MetaEvent =
        {
            description = 'MetaEvent',
            default = 'Sometimes',
            type = Enum,
            values = {
                'Never',
                'Sometimes'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_MetaEvent(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.MetaEvent.values
                 return values[ZomboidSandboxVarsInterface.instance:get_MetaEvent()]
            end
        },
        SleepingEvent =
        {
            description = 'SleepingEvent',
            default = 'Sometimes',
            type = Enum,
            values = {
                'Never',
                'Sometimes'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_SleepingEvent(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.SleepingEvent.values
                 return values[ZomboidSandboxVarsInterface.instance:get_SleepingEvent()]
            end
        },
        GeneratorSpawning =
        {
            description = 'GeneratorSpawning',
            default = 'Sometimes',
            type = Enum,
            values = {
                'Extremely Rare',
                'Rare',
                'Sometimes',
                'Often'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_GeneratorSpawning(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.GeneratorSpawning.values
                 return values[ZomboidSandboxVarsInterface.instance:get_GeneratorSpawning()]
            end
        },
        GeneratorFuelConsumption =
        {
            description = 'GeneratorFuelConsumption',
            default = 1.0,
            type = FloatRange,
            minimum = 0.0,
            maximum = 100.0,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_GeneratorFuelConsumption(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_GeneratorFuelConsumption()
            end
        },
        SurvivorHouseChance =
        {
            description = 'SurvivorHouseChance',
            default = 'Rare',
            type = Enum,
            values = {
                'Never',
                'Extremely Rare',
                'Rare',
                'Sometimes',
                'Often'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_SurvivorHouseChance(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.SurvivorHouseChance.values
                 return values[ZomboidSandboxVarsInterface.instance:get_SurvivorHouseChance()]
            end
        },
        VehicleStoryChance =
        {
            description = 'VehicleStoryChance',
            default = 'Rare',
            type = Enum,
            values = {
                'Never',
                'Extremely Rare',
                'Rare',
                'Sometimes',
                'Often'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_VehicleStoryChance(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.VehicleStoryChance.values
                 return values[ZomboidSandboxVarsInterface.instance:get_VehicleStoryChance()]
            end
        },
        ZoneStoryChance =
        {
            description = 'ZoneStoryChance',
            default = 'Rare',
            type = Enum,
            values = {
                'Never',
                'Extremely Rare',
                'Rare',
                'Sometimes',
                'Often'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZoneStoryChance(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.ZoneStoryChance.values
                 return values[ZomboidSandboxVarsInterface.instance:get_ZoneStoryChance()]
            end
        },
        AnnotatedMapChance =
        {
            description = 'AnnotatedMapChance',
            default = 'Sometimes',
            type = Enum,
            values = {
                'Never',
                'Extremely Rare',
                'Rare',
                'Sometimes',
                'Often'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_AnnotatedMapChance(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.AnnotatedMapChance.values
                 return values[ZomboidSandboxVarsInterface.instance:get_AnnotatedMapChance()]
            end
        },
        CharacterFreePoints =
        {
            description = 'CharacterFreePoints',
            default = 0,
            type = IntegerRange,
            minimum = -100,
            maximum = 100,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_CharacterFreePoints(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_CharacterFreePoints()
            end
        },
        ConstructionBonusPoints =
        {
            description = 'ConstructionBonusPoints',
            default = 'Normal',
            type = Enum,
            values = {
                'Very Low',
                'Low',
                'Normal',
                'High'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ConstructionBonusPoints(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.ConstructionBonusPoints.values
                 return values[ZomboidSandboxVarsInterface.instance:get_ConstructionBonusPoints()]
            end
        },
        NightDarkness =
        {
            description = 'NightDarkness',
            default = 'Normal',
            type = Enum,
            values = {
                'Pitch Black',
                'Dark',
                'Normal'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_NightDarkness(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.NightDarkness.values
                 return values[ZomboidSandboxVarsInterface.instance:get_NightDarkness()]
            end
        },
        NightLength =
        {
            description = 'NightLength',
            default = 'Normal',
            type = Enum,
            values = {
                'Always Night',
                'Long',
                'Normal',
                'Short'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_NightLength(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.NightLength.values
                 return values[ZomboidSandboxVarsInterface.instance:get_NightLength()]
            end
        },
        InjurySeverity =
        {
            description = 'InjurySeverity',
            default = 'Normal',
            type = Enum,
            values = {
                'Low',
                'Normal'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_InjurySeverity(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.InjurySeverity.values
                 return values[ZomboidSandboxVarsInterface.instance:get_InjurySeverity()]
            end
        },
        BoneFracture =
        {
            description = 'BoneFracture',
            default = true,
            type = Boolean,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_BoneFracture(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_BoneFracture()
            end
        },
        HoursForCorpseRemoval =
        {
            description = 'HoursForCorpseRemoval',
            default = 216.0,
            type = FloatRange,
            minimum = -1.00,
            maximum = 2147483647.00,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_HoursForCorpseRemoval(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_HoursForCorpseRemoval()
            end
        },
        DecayingCorpseHealthImpact =
        {
            description = 'DecayingCorpseHealthImpact',
            default = 'Normal',
            type = Enum,
            values = {
                'None',
                'Low',
                'Normal'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_DecayingCorpseHealthImpact(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.DecayingCorpseHealthImpact.values
                 return values[ZomboidSandboxVarsInterface.instance:get_DecayingCorpseHealthImpact()]
            end
        },
        BloodLevel =
        {
            description = 'BloodLevel',
            default = 'Normal',
            type = Enum,
            values = {
                'None',
                'Low',
                'Normal',
                'High',
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_BloodLevel(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.BloodLevel.values
                 return values[ZomboidSandboxVarsInterface.instance:get_BloodLevel()]
            end
        },
        ClothingDegradation =
        {
            description = 'ClothingDegradation',
            default = 'Normal',
            type = Enum,
            values = {
                'Disabled',
                'Slow',
                'Normal'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ClothingDegradation(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.ClothingDegradation.values
                 return values[ZomboidSandboxVarsInterface.instance:get_ClothingDegradation()]
            end
        },
        FireSpread =
        {
            description = 'FireSpread',
            default = true,
            type = Boolean,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_FireSpread(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_FireSpread()
            end
        },
        DaysForRottenFoodRemoval = 
        {
            description = 'DaysForRottenFoodRemoval',
            default = -1,
            type = IntegerRange,
            minimum = -1,
            maximum = 2147483647,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_DaysForRottenFoodRemoval(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_DaysForRottenFoodRemoval()
            end
        },
        AllowExteriorGenerator =
        {
            description = 'AllowExteriorGenerator',
            default = true,
            type = Boolean,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_AllowExteriorGenerator(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_AllowExteriorGenerator()
            end
        },
        MaxFogIntensity =
        {
            description = 'MaxFogIntensity',
            default = 'Normal',
            type = Enum,
            values = {
                'Normal',
                'Moderate'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_MaxFogIntensity(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.MaxFogIntensity.values
                 return values[ZomboidSandboxVarsInterface.instance:get_MaxFogIntensity()]
            end
        },
        MaxRainFxIntensity =
        {
            description = 'MaxRainFxIntensity',
            default = 'Normal',
            type = Enum,
            values = {
                'Normal',
                'Moderate'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_MaxRainFxIntensity(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.MaxRainFxIntensity.values
                 return values[ZomboidSandboxVarsInterface.instance:get_MaxRainFxIntensity()]
            end
        },
        EnableSnowOnGround =
        {
            description = 'EnableSnowOnGround',
            type = Boolean,
            default = true,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_EnableSnowOnGround(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_EnableSnowOnGround()
            end
        },
        MultiHitZombies =
        {
            description = 'MultiHitZombies',
            default = true,
            type = Boolean,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_MultiHitZombies(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_MultiHitZombies()
            end
        },
        RearVulnerability =
        {
            description = 'RearVulnerability',
            default = 'High',
            type = Enum,
            values = {
                'Low',
                'Medium',
                'High'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_RearVulnerability(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.RearVulnerability.values
                 return values[ZomboidSandboxVarsInterface.instance:get_RearVulnerability()]
            end
        },
        AttackBlockMovements =
        {
            description = 'AttackBlockMovements',
            default = true,
            type = Boolean,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_AttackBlockMovements(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_AttackBlockMovements()
            end
        },
        AllClothesUnlocked =
        {
            description = 'AllClothesUnlocked',
            default = false,
            type = Boolean,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_AllClothesUnlocked(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_AllClothesUnlocked()
            end
        },
        EnableTaintedWaterText =
        {
            description = 'EnableTaintedWaterText',
            default = true,
            type = Boolean,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_EnableTaintedWaterText(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_EnableTaintedWaterText()
            end
        },
        CarSpawnRate =
        {
            description = 'CarSpawnRate',
            default = 'Low',
            type = Enum,
            values = {
                'None',
                'Very Low',
                'Low',
                'Normal'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_CarSpawnRate(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.CarSpawnRate.values
                 return values[ZomboidSandboxVarsInterface.instance:get_CarSpawnRate()]
            end
        },
        ChanceHasGas =
        {
            description = 'ChanceHasGas',
            default = 'Normal',
            type = Enum,
            values = {
                'Low',
                'Normal'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ChanceHasGas(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.ChanceHasGas.values
                 return values[ZomboidSandboxVarsInterface.instance:get_ChanceHasGas()]
            end
        },
        InitialGas =
        {
            description = 'InitialGas',
            default = 'Low',
            type = Enum,
            values = {
                'Very Low',
                'Low',
                'Normal',
                'High',
                'Very High'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_InitialGas(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.InitialGas.values
                 return values[ZomboidSandboxVarsInterface.instance:get_InitialGas()]
            end
        },
        FuelStationGas =
        {
            description = 'FuelStationGas',
            default = 'Normal',
            type = Enum,
            values = {
                'Empty',
                'Super Low',
                'Very Low',
                'Low',
                'Normal',
                'High',
                'Very High',
                'Full'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_FuelStationGas(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.FuelStationGas.values
                 return values[ZomboidSandboxVarsInterface.instance:get_FuelStationGas()]
            end
        },
        CarGasConsumption =
        {
            description = 'CarGasConsumption',
            default = 1.0,
            type = FloatRange,
            minimum = 0.0,
            Maximum = 100.0,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_CarGasConsumption(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_CarGasConsumption()
            end
        },
        LockedCar =
        {
            description = 'LockedCar',
            default = 'Rare',
            type = Enum,
            values = {
                'Never',
                'Extremely Rare',
                'Rare',
                'Sometimes',
                'Often'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_LockedCar(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.LockedCar.values
                 return values[ZomboidSandboxVarsInterface.instance:get_LockedCar()]
            end
        },
        CarGeneralCondition =
        {
            description = 'CarGeneralCondition',
            default = 'Low',
            type = Enum,
            values = {
                'Very Low',
                'Low',
                'Normal',
                'High'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_CarGeneralCondition(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.CarGeneralCondition.values
                 return values[ZomboidSandboxVarsInterface.instance:get_CarGeneralCondition()]
            end
        },
        CarDamageOnImpact =
        {
            description = 'CarDamageOnImpact',
            default = 'Normal',
            type = Enum,
            values = {
                'None',
                'Low',
                'Normal',
                'High'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_CarDamageOnImpact(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.CarDamageOnImpact.values
                 return values[ZomboidSandboxVarsInterface.instance:get_CarDamageOnImpact()]
            end
        },
        DamageToPlayerFromHitByACar =
        {
            description = 'DamageToPlayerFromHitByACar',
            default = 'Low',
            type = Enum,
            values = {
                'None',
                'Low',
                'Normal',
                'High'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_DamageToPlayerFromHitByACar(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.DamageToPlayerFromHitByACar.values
                 return values[ZomboidSandboxVarsInterface.instance:get_DamageToPlayerFromHitByACar()]
            end
        },
        TrafficJam =
        {
            description = 'TrafficJam',
            default = true,
            type = Boolean,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_TrafficJam(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_TrafficJam()
            end
        },
        CarAlarm =
        {
            description = 'CarAlarm',
            default = 'Extremely Rare',
            type = Enum,
            values = {
                'Never',
                'Extremely Rare',
                'Rare',
                'Sometimes',
                'Often',
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_CarAlarm(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.CarAlarm.values
                 return values[ZomboidSandboxVarsInterface.instance:get_CarAlarm()]
            end
        },
        PlayerDamageFromCrash =
        {
            description = 'PlayerDamageFromCrash',
            default = true,
            type = Boolean,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_PlayerDamageFromCrash(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_PlayerDamageFromCrash()
            end
        },
        SirenShutoffHours =
        {
            description = 'SirenShutoffHours',
            default = 0,
            type = FloatRange,
            minimum = 0.0,
            maximum = 168.00,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_SirenShutoffHours(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_SirenShutoffHours()
            end
        },
        RecentlySurvivorVehicles =
        {
            description = 'RecentlySurvivorVehicles',
            default = 'Low',
            type = Enum,
            values = {
                'None',
                'Low',
                'Normal'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_RecentlySurvivorVehicles(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.RecentlySurvivorVehicles.values
                 return values[ZomboidSandboxVarsInterface.instance:get_RecentlySurvivorVehicles()]
            end
        },
        EnableVehicles =
        {
            description = 'EnableVehicles',
            default = true,
            type = Boolean,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_EnableVehicles(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_EnableVehicles()
            end
        },
        EnablePoisoning =
        {
            description = 'EnablePoisoning',
            default = true,
            type = Boolean,
            setter = function(v)
                -- 1 is true, 2 is false in the config
                -- not sure why
                local assign_to = 1
                if v then
                    assign_to = 1
                else
                    assign_to = 2
                end
                ZomboidSandboxVarsInterface.instance:set_EnablePoisoning(assign_to)
            end,
            getter = function()
                local v = ZomboidSandboxVarsInterface.instance:get_EnablePoisoning()
                if v == 1 then
                    return true
                else
                    return false
                end
            end
        },
        MaggotSpawn =
        {
            description = 'MaggotSpawn',
            default = 'In and around bodies',
            type = Enum,
            values = {
                'In and around bodies',
                'In bodies only'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_MaggotSpawn(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.MaggotSpawn.values
                 return values[ZomboidSandboxVarsInterface.instance:get_MaggotSpawn()]
            end
        },
        LightBulbLifespan =
        {
            description = 'LightBulbLifespan',
            default = 1.0,
            type = FloatRange,
            minimum = 0.0,
            maximum = 1000.00,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_LightBulbLifespan(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_LightBulbLifespan()
            end
        },
        Map_AllowMiniMap =
        {
            description = 'Map.AllowMiniMap',
            default = false,
            type = Boolean,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_Map_AllowMiniMap(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_Map_AllowMiniMap()
            end
        },
        Map_AllowWorldMap =
        {
            description = 'Map.AllowWorldMap',
            default = true,
            type = Boolean,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_Map_AllowWorldMap(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_Map_AllowWorldMap()
            end
        },
        Map_AllKnown =
        {
            description = 'Map.AllKnown',
            default = false,
            type = Boolean,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_Map_AllKnown(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_Map_AllKnown()
            end
        },
        ZombieLore_Speed =
        {
            description = 'ZombieLore.Speed',
            default = 'Fast Shamblers',
            type = Enum,
            values = {
                'Sprinters',
                'Fast Shamblers',
                'Shamblers'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieLore_Speed(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.ZombieLore_Speed.values
                 return values[ZomboidSandboxVarsInterface.instance:get_ZombieLore_Speed()]
            end
        },
        ZombieLore_Strength =
        {
            description = 'ZombieLore.Strength',
            default = 'Normal',
            type = Enum,
            values = {
                'Superhuman',
                'Normal',
                'Weak'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieLore_Strength(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.ZombieLore_Strength.values
                 return values[ZomboidSandboxVarsInterface.instance:get_ZombieLore_Strength()]
            end
        },
        ZombieLore_Toughness =
        {
            description = 'ZombieLore.Toughness',
            default = 'Normal',
            type = Enum,
            values = {
                'Tough',
                'Normal',
                'Fragile'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieLore_Toughness(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.ZombieLore_Toughness.values
                 return values[ZomboidSandboxVarsInterface.instance:get_ZombieLore_Toughness()]
            end
        },
        ZombieLore_Transmission =
        {
            description = 'ZombieLore.Transmission',
            default = 'Blood + Saliva',
            type = Enum,
            values = {
                'Blood + Saliva',
                'Saliva Only',
                'Everyone\'s Infected'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieLore_Transmission(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.ZombieLore_Transmission.values
                 return values[ZomboidSandboxVarsInterface.instance:get_ZombieLore_Transmission()]
            end
        },
        ZombieLore_Mortality =
        {
            description = 'ZombieLore.Mortality',
            default = '2-3 Days',
            type = Enum,
            values = {
                'Instant',
                '0-30 Seconds',
                '0-1 Minutes',
                '0-12 Hours',
                '2-3 Days',
                '1-2 Weeks'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieLore_Mortality(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.ZombieLore_Mortality.values
                 return values[ZomboidSandboxVarsInterface.instance:get_ZombieLore_Mortality()]
            end
        },
        ZombieLore_Reanimate =
        {
            description = 'ZombieLore.Mortality',
            default = '2-3 Days',
            type = Enum,
            values = {
                'Instant',
                '0-30 Seconds',
                '0-1 Minutes',
                '0-12 Hours',
                '2-3 Days'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieLore_Reanimate(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.ZombieLore_Reanimate.values
                 return values[ZomboidSandboxVarsInterface.instance:get_ZombieLore_Reanimate()]
            end
        },
        ZombieLore_Cognition =
        {
            description = 'ZombieLore.Cognition',
            default = 'Basic Navigation',
            type = Enum,
            values = {
                'Navigate + Use Doors',
                'Navigate',
                'Basic Navigation'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieLore_Cognition(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.ZombieLore_Cognition.values
                 return values[ZomboidSandboxVarsInterface.instance:get_ZombieLore_Cognition()]
            end
        },
        ZombieLore_CrawlUnderVehicle =
        {
            description = 'ZombieLore.CrawlUnderVehicle',
            default = 'Often',
            type = Enum,
            values = {
                'Crawlers Only',
                'Extremely Rare',
                'Rare',
                'Sometimes',
                'Often',
                'Very Often'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieLore_CrawlUnderVehicle(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.ZombieLore_CrawlUnderVehicle.values
                 return values[ZomboidSandboxVarsInterface.instance:get_ZombieLore_CrawlUnderVehicle()]
            end
        },
        ZombieLore_Memory =
        {
            description = 'ZombieLore.Memory',
            default = 'Normal',
            type = Enum,
            values = {
                'Long',
                'Normal',
                'Short',
                'None'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieLore_Memory(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.ZombieLore_Memory.values
                 return values[ZomboidSandboxVarsInterface.instance:get_ZombieLore_Memory()]
            end
        },
        ZombieLore_Sight =
        {
            description = 'ZombieLore.Sight',
            default = 'Normal',
            type = Enum,
            values = {
                'Eagle',
                'Normal',
                'Poor'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieLore_Sight(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.ZombieLore_Sight.values
                 return values[ZomboidSandboxVarsInterface.instance:get_ZombieLore_Sight()]
            end
        },
        ZombieLore_Hearing =
        {
            description = 'ZombieLore.Hearing',
            default = 'Normal',
            type = Enum,
            values = {
                'Pinpoint',
                'Normal',
                'Poor'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieLore_Hearing(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.ZombieLore_Hearing.values
                 return values[ZomboidSandboxVarsInterface.instance:get_ZombieLore_Hearing()]
            end
        },
        ZombieLore_ThumpNoChasing =
        {
            description = 'ZombieLore.ThumpNoChasing',
            default = false,
            type = Boolean,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieLore_ThumpNoChasing(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_ZombieLore_ThumpNoChasing()
            end
        },
        ZombieLore_ThumpOnConstruction = {
            description = 'ZombieLore.ThumpOnConstruction',
            default = true,
            type = Boolean,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieLore_ThumpOnConstruction(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_ZombieLore_ThumpOnConstruction()
            end
        },
        ZombieLore_ActiveOnly = {
            description = 'ZombieLore.ActiveOnly',
            default = 'Night and Day',
            type = Enum,
            values = {
                'Night and Day',
                'Night Only'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieLore_ActiveOnly(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.ZombieLore_ActiveOnly.values
                 return values[ZomboidSandboxVarsInterface.instance:get_ZombieLore_ActiveOnly()]
            end
        },
        ZombieLore_TriggerHouseAlarm = {
            description = 'ZombieLore.TriggerHouseAlarm',
            default = false,
            type = Boolean,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieLore_TriggerHouseAlarm(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_ZombieLore_TriggerHouseAlarm()
            end
        },
        ZombieLore_ZombiesDragDown = {
            description = 'ZombieLore.ZombiesDragDown',
            default = true,
            type = Boolean,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieLore_ZombiesDragDown(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_ZombieLore_ZombiesDragDown()
            end
        },
        ZombieLore_ZombiesFenceLunge = {
            description = 'ZombieLore.ZombiesFenceLunge',
            default = true,
            type = Boolean,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieLore_ZombiesFenceLunge(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_ZombieLore_ZombiesFenceLunge()
            end
        },
        ZombieLore_DisableFakeDead = {
            description = 'ZombieLore.DisableFakeDead',
            default = 'Some zombies will pretend to be dead.',
            type = Enum,
            values = {
                'Some zombies will pretend to be dead.',
                'Some zombies in the world, as well as some you \'kill\', can pretend to be dead.'
            },
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieLore_DisableFakeDead(v + 1)
            end,
            getter = function()
                 local values = ZomboidSandboxVarsInterface.schema.ZombieLore_DisableFakeDead.values
                 return values[ZomboidSandboxVarsInterface.instance:get_ZombieLore_DisableFakeDead()]
            end
        },
        ZombieConfig_PopulationMultiplier = {
            description = 'ZombieConfig.PopulationMultiplier',
            default = 1.0,
            type = FloatRange,
            minimum = 0.0,
            maximum = 4.0,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieConfig_PopulationMultiplier(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_ZombieConfig_PopulationMultiplier()
            end
        },
        ZombieConfig_PopulationStartMultiplier = {
            description = 'ZombieConfig.PopulationStartMultiplier',
            default = 1.0,
            type = FloatRange,
            minimum = 0.0,
            maximum = 4.0,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieConfig_PopulationStartMultiplier(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_ZombieConfig_PopulationStartMultiplier()
            end
        },
        ZombieConfig_PopulationPeakMultiplier = {
            description = 'ZombieConfig.PopulationPeakMultiplier',
            default = 1.5,
            type = FloatRange,
            minimum = 0.0,
            maximum = 4.0,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieConfig_PopulationPeakMultiplier(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_ZombieConfig_PopulationPeakMultiplier()
            end
        },
        ZombieConfig_PopulationPeakDay = {
            description = 'ZombieConfig.PopulationPeakDay',
            default = 28,
            type = IntegerRange,
            minimum = 1,
            maximum = 365,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieConfig_PopulationPeakDay(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_ZombieConfig_PopulationPeakDay()
            end
        },
        ZombieConfig_RespawnHours = {
            description = 'ZombieConfig.RespawnHours',
            default = 72.0,
            type = FloatRange,
            minimum = 0.0,
            maximum = 8760.00,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieConfig_RespawnHours(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_ZombieConfig_RespawnHours()
            end
        },
        ZombieConfig_RespawnUnseenHours = {
            description = 'ZombieConfig.RespawnUnseenHours',
            default = 16.0,
            type = FloatRange,
            minimum = 0.0,
            maximum = 8760.00,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieConfig_RespawnUnseenHours(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_ZombieConfig_RespawnUnseenHours()
            end
        },
        ZombieConfig_RespawnMultiplier = {
            description = 'ZombieConfig.RespawnMultiplier',
            default = 0.1,
            type = FloatRange,
            minimum = 0.0,
            maximum = 1.0,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieConfig_RespawnMultiplier(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_ZombieConfig_RespawnMultiplier()
            end
        },
        ZombieConfig_RedistributeHours = {
            description = 'ZombieConfig.RedistributeHours',
            default = 12.0,
            type = FloatRange,
            minimum = 0.0,
            maximum = 8760.00,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieConfig_RedistributeHours(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_ZombieConfig_RedistributeHours()
            end
        },
        ZombieConfig_FollowSoundDistance = {
            description = 'ZombieConfig.FollowSoundDistance',
            default = 100,
            type = IntegerRange,
            minimum = 10,
            maximum = 1000,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieConfig_FollowSoundDistance(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_ZombieConfig_FollowSoundDistance()
            end
        },
        ZombieConfig_RallyGroupSize = {
            description = 'ZombieConfig.RallyGroupSize',
            default = 20,
            type = IntegerRange,
            minimum = 10,
            maximum = 1000,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieConfig_RallyGroupSize(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_ZombieConfig_RallyGroupSize()
            end
        },
        ZombieConfig_RallyTravelDistance = {
            description = 'ZombieConfig.RallyTravelDistance',
            default = 20,
            type = IntegerRange,
            minimum=5,
            maximum=50,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieConfig_RallyTravelDistance(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_ZombieConfig_RallyTravelDistance()
            end
        },
        ZombieConfig_RallyGroupSeparation = {
            description = 'ZombieConfig.RallyGroupSeparation',
            default = 15,
            type = IntegerRange,
            minimum=5,
            maximum=25,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieConfig_RallyGroupSeparation(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_ZombieConfig_RallyGroupSeparation()
            end
        },
        ZombieConfig_RallyGroupRadius = {
            description = 'ZombieConfig.RallyGroupRadius',
            default = 3,
            type = IntegerRange,
            minimum = 1,
            maximum = 10,
            setter = function(v)
                ZomboidSandboxVarsInterface.instance:set_ZombieConfig_RallyGroupRadius(v)
            end,
            getter = function()
                return ZomboidSandboxVarsInterface.instance:get_ZombieConfig_RallyGroupRadius()
            end
        }
    }
}

register_plugin('Zomboid', 'Sandbox Config', ZomboidSandboxVarsInterface)
