ZomboidServer = {
    ['PVP'] = true,
    ['PauseEmpty'] = true,
    ['GlobalChat'] = true,
    ['ChatStreams'] = 's,r,a,w,y,sh,f,all',
    ['Open'] = true,
    ['ServerWelcomeMessage'] = 'Good luck. Dont die or eat mushrooms',
    ['AutoCreateUserInWhiteList'] = false,
    ['DisplayUserName'] = true,
    ['ShowFirstAndLastName'] = false,
    ['SpawnPoint'] = '0,0,0',
    ['SafetySystem'] = true,
    ['ShowSafety'] = true,
    ['SafetyToggleTimer'] = 2,
    ['SafetyCooldownTimer'] = 3,
    ['SpawnItems'] = '',
    ['DefaultPort'] = 8766,
    ['UDPPort'] = 8767,
    ['ResetID'] = 1176218,
    ['Mods'] = '',
    ['Map'] = 'Muldraugh, KY',
    ['DoLuaChecksum'] = true,
    ['DenyLoginOnOverloadedServer'] = true,
    ['Public'] = true,
    ['PublicName'] = 'Project Zomboid Server',
    ['PublicDescription'] = '[Redacted]',
    ['MaxPlayers'] = '8',
    ['PingLimit'] = 400,
    ['HoursForLootRespawn'] = 0,
    ['MaxItemsForLootRespawn'] = 4,
    ['ConstructionPreventsLootRespawn'] = true,
    ['DropOffWhiteListAfterDeath'] = false,
    ['NoFire'] = false,
    ['AnnounceDeath'] = false,
    ['MinutesPerPage'] = 0.7,
    ['SaveWorldEveryMinutes'] = 10,
    ['PlayerSafehouse'] = false,
    ['AdminSafehouse'] = false,
    ['SafehouseAllowTrepass'] = true,
    ['SafehouseAllowFire'] = true,
    ['SafehouseAllowLoot'] = true,
    ['SafehouseAllowRespawn'] = false,
    ['SafehouseDaySurvivedToClaim'] = 0,
    ['SafeHouseRemovalTime'] = '144',
    ['SafehouseAllowNonResidential'] = false,
    ['AllowDestructionBySledgehammer'] = true,
    ['SledgehammerOnlyInSafehouse'] = false,
    ['KickFastPlayers'] = false,
    ['ServerPlayerID'] = 514776408,
    ['RCONPort'] = 27015,
    ['RCONPassword'] = '61yejbpn',
    ['DiscordEnable'] = false,
    ['DiscordToken'] = '',
    ['DiscordChannel'] = '',
    ['DiscordChannelID'] = '',
    ['Password'] = 'simonsfault',
    ['MaxAccountsPerUser'] = 10,
    ['AllowCoop'] = true,
    ['SleepAllowed'] = false,
    ['SleepNeeded'] = false,
    ['KnockedDownAllowed'] = true,
    ['SneakModeHideFromOtherPlayers'] = true,
    ['WorkshopItems'] = '',
    ['SteamScoreboard'] = true,
    ['SteamVAC'] = true,
    ['UPnP'] = false,
    ['VoiceEnable'] = true,
    ['VoiceMinDistance'] = 10.0,
    ['VoiceMaxDistance'] = 300.0,
    ['Voice3D'] = true,
    ['SpeedLimit'] = 70.0,
    ['LoginQueueEnabled'] = false,
    ['LoginQueueConnectTimeout'] = 60,
    ['server_browser_announced_ip'] = '',
    ['PlayerRespawnWithSelf'] = false,
    ['PlayerRespawnWithOther'] = false,
    ['FastForwardMultiplier'] = 40.0,
    ['DisableSafehouseWhenPlayerConnected'] = false,
    ['Faction'] = true,
    ['FactionDaySurvivedToCreate'] = 0,
    ['FactionPlayersRequiredForTag'] = 1,
    ['DisableRadioStaff'] = false,
    ['DisableRadioAdmin'] = true,
    ['DisableRadioGM'] = true,
    ['DisableRadioOverseer'] = false,
    ['DisableRadioModerator'] = false,
    ['DisableRadioInvisible'] = true,
    ['ClientCommandFilter'] =
    '-vehicle.*;+vehicle.damageWindow;+vehicle.fixPart;+vehicle.installPart;+vehicle.uninstallPart',
    ['ClientActionLogs'] = 'ISEnterVehicle;ISExitVehicle;ISTakeEngineParts;',
    ['PerkLogs'] = true,
    ['ItemNumbersLimitPerContainer'] = 0,
    ['BloodSplatLifespanDays'] = 0,
    ['AllowNonAsciiUsername'] = false,
    ['BanKickGlobalSound'] = true,
    ['RemovePlayerCorpsesOnCorpseRemoval'] = false,
    ['TrashDeleteAll'] = true,
    ['PVPMeleeWhileHitReaction'] = false,
    ['MouseOverToSeeDisplayName'] = true,
    ['HidePlayersBehindYou'] = true,
    ['PVPMeleeDamageModifier'] = 30.0,
    ['PVPFirearmDamageModifier'] = 50.0,
    ['CarEngineAttractionModifier'] = 0.5,
    ['PlayerBumpPlayer'] = false,
    ['MapRemotePlayerVisibility'] = 3,
    ['BackupsCount'] = 5,
    ['BackupsOnStart'] = true,
    ['BackupsOnVersionChange'] = true,
    ['BackupsPeriod'] = '0',
    ['AntiCheatProtectionType1'] = true,
    ['AntiCheatProtectionType2'] = true,
    ['AntiCheatProtectionType3'] = true,
    ['AntiCheatProtectionType4'] = true,
    ['AntiCheatProtectionType5'] = true,
    ['AntiCheatProtectionType6'] = true,
    ['AntiCheatProtectionType7'] = true,
    ['AntiCheatProtectionType8'] = true,
    ['AntiCheatProtectionType9'] = true,
    ['AntiCheatProtectionType10'] = true,
    ['AntiCheatProtectionType11'] = true,
    ['AntiCheatProtectionType12'] = true,
    ['AntiCheatProtectionType13'] = true,
    ['AntiCheatProtectionType14'] = true,
    ['AntiCheatProtectionType15'] = true,
    ['AntiCheatProtectionType16'] = true,
    ['AntiCheatProtectionType17'] = true,
    ['AntiCheatProtectionType18'] = true,
    ['AntiCheatProtectionType19'] = true,
    ['AntiCheatProtectionType20'] = true,
    ['AntiCheatProtectionType21'] = true,
    ['AntiCheatProtectionType22'] = true,
    ['AntiCheatProtectionType23'] = true,
    ['AntiCheatProtectionType24'] = true,
    ['AntiCheatProtectionType2ThresholdMultiplier'] = 3.0,
    ['AntiCheatProtectionType3ThresholdMultiplier'] = 1.0,
    ['AntiCheatProtectionType4ThresholdMultiplier'] = 1.0,
    ['AntiCheatProtectionType9ThresholdMultiplier'] = 1.0,
    ['AntiCheatProtectionType15ThresholdMultiplier'] = 1.0,
    ['AntiCheatProtectionType20ThresholdMultiplier'] = 1.0,
    ['AntiCheatProtectionType22ThresholdMultiplier'] = 1.0,
    ['AntiCheatProtectionType24ThresholdMultiplier'] = 6.0
}

ZomboidServer.__index = ZomboidServer

function ZomboidServer:new(o)
    o = o or {}
    setmetatable(o, self)
    o.__index = self
    return o
end

function ZomboidServer:set_pvp(v)
    self.PVP = v
end

function ZomboidServer:get_pvp()
    return self.PVP
end

function ZomboidServer:set_pause_empty(v)
    self.PauseEmpty = v
end

function ZomboidServer:get_pause_empty()
    return self.PauseEmpty
end

function ZomboidServer:set_global_chat(v)
    self.GlobalChat = v
end

function ZomboidServer:get_global_chat()
    return self.GlobalChat
end

function ZomboidServer:set_chat_streams(v)
    self.ChatStreams = v
end

function ZomboidServer:get_chat_streams()
    return self.ChatStreams
end

function ZomboidServer:set_open(v)
    self.Open = v
end

function ZomboidServer:get_open()
    local v = self.Open
    if type(v) == 'string' then
        if v == 'true' then
            v = true
        else
            v = false
        end
    end
    return v
end

function ZomboidServer:set_server_welcome_message(v)
    self.ServerWelcomeMessage = v
end

function ZomboidServer:get_server_welcome_message()
    return self.ServerWelcomeMessage
end

function ZomboidServer:set_auto_create_user_in_whitelist(v)
    self.AutoCreateUserInWhiteList = v
end

function ZomboidServer:get_auto_create_user_in_whitelist()
    return self.AutoCreateUserInWhiteList
end

function ZomboidServer:set_display_user_name(v)
    self.DisplayUserName = v
end

function ZomboidServer:get_display_user_name()
    return self.DisplayUserName
end

function ZomboidServer:set_show_first_and_last_name(v)
    self.ShowFirstAndLastName = v
end

function ZomboidServer:get_show_first_and_last_name()
    return self.ShowFirstAndLastName
end

function ZomboidServer:set_spawn_point(v)
    self.SpawnPoint = v
end

function ZomboidServer:get_spawn_point()
    return self.SpawnPoint
end

function ZomboidServer:set_safety_system(v)
    self.SafetySystem = v
end

function ZomboidServer:get_safety_system()
    return self.SafetySystem
end

function ZomboidServer:set_show_safety(v)
    self.ShowSafety = v
end

function ZomboidServer:get_show_safety()
    return self.ShowSafety
end

function ZomboidServer:set_safety_toggle_timer(v)
    self.SafetyToggleTimer = v
end

function ZomboidServer:get_safety_toggle_timer()
    return self.SafetyToggleTimer
end

function ZomboidServer:set_safety_cooldown_timer(v)
    self.SafetyCooldownTimer = v
end

function ZomboidServer:get_safety_cooldown_timer()
    return self.SafetyCooldownTimer
end

function ZomboidServer:set_spawn_items(v)
    self.SpawnItems = v
end

function ZomboidServer:get_spawn_items()
    return self.SpawnItems
end

function ZomboidServer:set_default_port(v)
    self.DefaultPort = v
end

function ZomboidServer:get_default_port()
    return self.DefaultPort
end

function ZomboidServer:set_udp_port(v)
    self.UDPPort = v
end

function ZomboidServer:get_udp_port()
    return self.UDPPort
end

function ZomboidServer:set_reset_id(v)
    self.ResetID = v
end

function ZomboidServer:get_reset_id()
    return self.ResetID
end

function ZomboidServer:set_mods(v)
    self.Mods = v
end

function ZomboidServer:get_mods()
    return self.Mods
end

function ZomboidServer:set_map(v)
    self.Map = v
end

function ZomboidServer:get_map()
    return self.Map
end

function ZomboidServer:set_do_lua_checksum(v)
    self.DoLuaChecksum = v
end

function ZomboidServer:get_do_lua_checksum()
    return self.DoLuaChecksum
end

function ZomboidServer:set_deny_login_on_overloaded_server(v)
    self.DenyLoginOnOverloadedServer = v
end

function ZomboidServer:get_deny_login_on_overloaded_server()
    return self.DenyLoginOnOverloadedServer
end

function ZomboidServer:set_public(v)
    self.Public = v
end

function ZomboidServer:get_public()
    return self.Public
end

function ZomboidServer:set_public_name(v)
    self.PublicName = v
end

function ZomboidServer:get_public_name()
    return self.PublicName
end

function ZomboidServer:set_public_description(v)
    self.PublicDescription = v
end

function ZomboidServer:get_public_description()
    return self.PublicDescription
end

function ZomboidServer:set_max_players(v)
    self.MaxPlayers = v
end

function ZomboidServer:get_max_players()
    return self.MaxPlayers
end

function ZomboidServer:set_ping_limit(v)
    self.PingLimit = v
end

function ZomboidServer:get_ping_limit()
    return self.PingLimit
end

function ZomboidServer:set_hours_for_loot_respawn(v)
    self.HoursForLootRespawn = v
end

function ZomboidServer:get_hours_for_loot_respawn()
    return self.HoursForLootRespawn
end

function ZomboidServer:set_max_items_for_loot_respawn(v)
    self.MaxItemsForLootRespawn = v
end

function ZomboidServer:get_max_items_for_loot_respawn()
    return self.MaxItemsForLootRespawn
end

function ZomboidServer:set_construction_prevents_loot_respawn(v)
    self.ConstructionPreventsLootRespawn = v
end

function ZomboidServer:get_construction_prevents_loot_respawn()
    return self.ConstructionPreventsLootRespawn
end

function ZomboidServer:set_drop_off_whitelist_after_death(v)
    self.DropOffWhiteListAfterDeath = v
end

function ZomboidServer:get_drop_off_whitelist_after_death()
    return self.DropOffWhiteListAfterDeath
end

function ZomboidServer:set_no_fire(v)
    self.NoFire = v
end

function ZomboidServer:get_no_fire()
    return self.NoFire
end

function ZomboidServer:set_announce_death(v)
    self.AnnounceDeath = v
end

function ZomboidServer:get_announce_death()
    return self.AnnounceDeath
end

function ZomboidServer:set_minutes_per_page(v)
    self.MinutesPerPage = v
end

function ZomboidServer:get_minutes_per_page()
    return self.MinutesPerPage
end

function ZomboidServer:set_save_world_every_n_minutes(v)
    self.SaveWorldEveryMinutes = v
end

function ZomboidServer:get_save_world_every_n_minutes()
    return self.SaveWorldEveryMinutes
end

function ZomboidServer:set_player_safehouse(v)
    self.PlayerSafehouse = v
end

function ZomboidServer:get_player_safehouse()
    return self.PlayerSafehouse
end

function ZomboidServer:set_admin_safehouse(v)
    self.AdminSafehouse = v
end

function ZomboidServer:get_admin_safehouse()
    return self.AdminSafehouse
end

function ZomboidServer:set_safehouse_allow_trespass(v)
    self.SafehouseAllowTrepass = v
end

function ZomboidServer:get_safehouse_allow_trespass()
    return self.SafehouseAllowTrepass
end

function ZomboidServer:set_safehouse_allow_fire(v)
    self.SafehouseAllowFire = v
end

function ZomboidServer:get_safehouse_allow_fire()
    return self.SafehouseAllowFire
end

function ZomboidServer:set_safehouse_allow_loot(v)
    self.SafehouseAllowLoot = v
end

function ZomboidServer:get_safehouse_allow_loot()
    return self.SafehouseAllowLoot
end

function ZomboidServer:set_safehouse_allow_respawn(v)
    self.SafehouseAllowRespawn = v
end

function ZomboidServer:get_safehouse_allow_respawn()
    return self.SafehouseAllowRespawn
end

function ZomboidServer:set_safehouse_day_survived_to_claim(v)
    self.SafehouseDaySurvivedToClaim = v
end

function ZomboidServer:get_safehouse_day_survived_to_claim()
    return self.SafehouseDaySurvivedToClaim
end

function ZomboidServer:set_safehouse_removal_time(v)
    self.SafeHouseRemovalTime = v
end

function ZomboidServer:get_safehouse_removal_time()
    return self.SafeHouseRemovalTime
end

function ZomboidServer:set_safehouse_allow_non_residential(v)
    self.SafehouseAllowNonResidential = v
end

function ZomboidServer:get_safehouse_allow_non_residential()
    return self.SafehouseAllowNonResidential
end

function ZomboidServer:set_allow_destruction_by_sledgehammer(v)
    self.AllowDestructionBySledgehammer = v
end

function ZomboidServer:get_allow_destruction_by_sledgehammer()
    return self.AllowDestructionBySledgehammer
end

function ZomboidServer:set_sledgehammer_only_in_safehouse(v)
    self.SledgehammerOnlyInSafehouse = v
end

function ZomboidServer:get_sledgehammer_only_in_safehouse()
    return self.SledgehammerOnlyInSafehouse
end

function ZomboidServer:set_kick_fast_players(v)
    self.KickFastPlayers = v
end

function ZomboidServer:get_kick_fast_players()
    return self.KickFastPlayers
end

function ZomboidServer:set_server_player_id(v)
    self.ServerPlayerID = v
end

function ZomboidServer:get_server_player_id()
    return self.ServerPlayerID
end

function ZomboidServer:set_rcon_port(v)
    self.RCONPort = v
end

function ZomboidServer:get_rcon_port()
    return self.RCONPort
end

function ZomboidServer:set_rcon_password(v)
    self.RCONPassword = v
end

function ZomboidServer:get_rcon_password()
    return self.RCONPassword
end

function ZomboidServer:set_discord_enable(v)
    self.DiscordEnable = v
end

function ZomboidServer:get_discord_enable()
    return self.DiscordEnable
end

function ZomboidServer:set_discord_token(v)
    self.DiscordToken = v
end

function ZomboidServer:get_discord_token()
    return self.DiscordToken
end

function ZomboidServer:set_discord_channel(v)
    self.DiscordChannel = v
end

function ZomboidServer:get_discord_channel()
    return self.DiscordChannel
end

function ZomboidServer:set_discord_channel_id(v)
    self.DiscordChannelID = v
end

function ZomboidServer:get_discord_channel_id()
    return self.DiscordChannelID
end

function ZomboidServer:set_password(v)
    self.Password = v
end

function ZomboidServer:get_password()
    return self.Password
end

function ZomboidServer:set_max_accounts_per_user(v)
    self.MaxAccountsPerUser = v
end

function ZomboidServer:get_max_accounts_per_user()
    return self.MaxAccountsPerUser
end

function ZomboidServer:set_allow_cooperative_play(v)
    self.AllowCoop = v
end

function ZomboidServer:get_allow_cooperative_play()
    return self.AllowCoop
end

function ZomboidServer:set_sleep_allowed(v)
    self.SleepAllowed = v
end

function ZomboidServer:get_sleep_allowed()
    return self.SleepAllowed
end

function ZomboidServer:set_sleep_needed(v)
    self.SleepNeeded = v
end

function ZomboidServer:get_sleep_needed()
    return self.SleepNeeded
end

function ZomboidServer:set_knocked_down_allowed(v)
    self.KnockedDownAllowed = v
end

function ZomboidServer:get_knocked_down_allowed()
    return self.KnockedDownAllowed
end

function ZomboidServer:set_sneak_mode_hide_from_other_players(v)
    self.SneakModeHideFromOtherPlayers = v
end

function ZomboidServer:get_sneak_mode_hide_from_other_players()
    return self.SneakModeHideFromOtherPlayers
end

function ZomboidServer:set_workshop_items(v)
    self.WorkshopItems = v
end

function ZomboidServer:get_workshop_items()
    return self.WorkshopItems
end

function ZomboidServer:set_steam_scoreboard(v)
    self.SteamScoreboard = v
end

function ZomboidServer:get_steam_scoreboard()
    return self.SteamScoreboard
end

function ZomboidServer:set_steam_vac(v)
    self.SteamVAC = v
end

function ZomboidServer:get_steam_vac()
    return self.SteamVAC
end

function ZomboidServer:set_upnp(v)
    self.UPnP = v
end

function ZomboidServer:get_upnp()
    return self.UPnP
end

function ZomboidServer:set_voice_enabled(v)
    self.VoiceEnable = v
end

function ZomboidServer:get_voice_enabled()
    return self.VoiceEnable
end

function ZomboidServer:set_voice_min_distance(v)
    self.VoiceMinDistance = v
end

function ZomboidServer:get_voice_min_distance()
    return self.VoiceMinDistance
end

function ZomboidServer:set_voice_max_distance(v)
    self.VoiceMaxDistance = v
end

function ZomboidServer:get_voice_max_distance()
    return self.VoiceMaxDistance
end

function ZomboidServer:set_voice_3d(v)
    self.Voice3D = v
end

function ZomboidServer:get_voice_3d()
    return self.Voice3D
end

function ZomboidServer:set_speed_limit(v)
    self.SpeedLimit = v
end

function ZomboidServer:get_speed_limit()
    return self.SpeedLimit
end

function ZomboidServer:set_login_queue_enabled(v)
    self.LoginQueueEnabled = v
end

function ZomboidServer:get_login_queue_enabled()
    return self.LoginQueueEnabled
end

function ZomboidServer:set_login_queue_connect_timeout(v)
    self.LoginQueueConnectTimeout = v
end

function ZomboidServer:get_login_queue_connect_timeout()
    return self.LoginQueueConnectTimeout
end

function ZomboidServer:set_server_browser_announced_ip(v)
    self.server_browser_announced_ip = v
end

function ZomboidServer:get_server_browser_announced_ip()
    return self.server_browser_announced_ip
end

function ZomboidServer:set_player_respawn_with_self(v)
    self.PlayerRespawnWithSelf = v
end

function ZomboidServer:get_player_respawn_with_self()
    return self.PlayerRespawnWithSelf
end

function ZomboidServer:set_player_respawn_with_other(v)
    self.PlayerRespawnWithOther = v
end

function ZomboidServer:get_player_respawn_with_other()
    return self.PlayerRespawnWithOther
end

function ZomboidServer:set_fast_forward_multiplier(v)
    self.FastForwardMultiplier = v
end

function ZomboidServer:get_fast_forward_multiplier()
    return self.FastForwardMultiplier
end

function ZomboidServer:set_disable_safehouse_when_player_connected(v)
    self.DisableSafehouseWhenPlayerConnected = v
end

function ZomboidServer:get_disable_safehouse_when_player_connected()
    return self.DisableSafehouseWhenPlayerConnected
end

function ZomboidServer:set_faction(v)
    self.Faction = v
end

function ZomboidServer:get_faction()
    return self.Faction
end

function ZomboidServer:set_faction_day_survived_to_create(v)
    self.FactionDaySurvivedToCreate = v
end

function ZomboidServer:get_faction_day_survived_to_create()
    return self.FactionDaySurvivedToCreate
end

function ZomboidServer:set_faction_players_required_for_tag(v)
    self.FactionPlayersRequiredForTag = v
end

function ZomboidServer:get_faction_players_required_for_tag()
    return self.FactionPlayersRequiredForTag
end

function ZomboidServer:set_disable_radio_staff(v)
    self.DisableRadioStaff = v
end

function ZomboidServer:get_disable_radio_staff()
    return self.DisableRadioStaff
end

function ZomboidServer:set_disable_radio_admin(v)
    self.DisableRadioAdmin = v
end

function ZomboidServer:get_disable_radio_admin()
    return self.DisableRadioAdmin
end

function ZomboidServer:set_disable_radio_gm(v)
    self.DisableRadioGM = v
end

function ZomboidServer:get_disable_radio_gm()
    return self.DisableRadioGM
end

function ZomboidServer:set_disable_radio_overseer(v)
    self.DisableRadioOverseer = v
end

function ZomboidServer:get_disable_radio_overseer()
    return self.DisableRadioOverseer
end

function ZomboidServer:set_disable_radio_moderator(v)
    self.DisableRadioModerator = v
end

function ZomboidServer:get_disable_radio_moderator()
    return self.DisableRadioModerator
end

function ZomboidServer:set_disable_radio_invisible(v)
    self.DisableRadioInvisible = v
end

function ZomboidServer:get_disable_radio_invisible()
    return self.DisableRadioInvisible
end

function ZomboidServer:set_client_command_filter(v)
    self.ClientCommandFilter = v
end

function ZomboidServer:get_client_command_filter()
    return self.ClientCommandFilter
end

function ZomboidServer:set_client_action_logs(v)
    self.ClientActionLogs = v
end

function ZomboidServer:get_client_action_logs()
    return self.ClientActionLogs
end

function ZomboidServer:set_perk_logs(v)
    self.PerkLogs = v
end

function ZomboidServer:get_perk_logs()
    return self.PerkLogs
end

function ZomboidServer:set_item_numbers_limit_per_container(v)
    self.ItemNumbersLimitPerContainer = v
end

function ZomboidServer:get_item_numbers_limit_per_container()
    return self.ItemNumbersLimitPerContainer
end

function ZomboidServer:set_blood_splat_lifespan_days(v)
    self.BloodSplatLifespanDays = v
end

function ZomboidServer:get_blood_splat_lifespan_days()
    return self.BloodSplatLifespanDays
end

function ZomboidServer:set_allow_non_ascii_username(v)
    self.AllowNonAsciiUsername = v
end

function ZomboidServer:get_allow_non_ascii_username()
    return self.AllowNonAsciiUsername
end

function ZomboidServer:set_ban_kick_global_sound(v)
    self.BanKickGlobalSound = v
end

function ZomboidServer:get_ban_kick_global_sound()
    return self.BanKickGlobalSound
end

function ZomboidServer:set_remove_player_corpses_on_corpse_removal(v)
    self.RemovePlayerCorpsesOnCorpseRemoval = v
end

function ZomboidServer:get_remove_player_corpses_on_corpse_removal()
    return self.RemovePlayerCorpsesOnCorpseRemoval
end

function ZomboidServer:set_trash_delete_all(v)
    self.TrashDeleteAll = v
end

function ZomboidServer:get_trash_delete_all()
    return self.TrashDeleteAll
end

function ZomboidServer:set_pvp_melee_while_hit_reaction(v)
    self.PVPMeleeWhileHitReaction = v
end

function ZomboidServer:get_pvp_melee_while_hit_reaction()
    return self.PVPMeleeWhileHitReaction
end

function ZomboidServer:set_mouse_over_to_see_display_name(v)
    self.MouseOverToSeeDisplayName = v
end

function ZomboidServer:get_mouse_over_to_see_display_name()
    return self.MouseOverToSeeDisplayName
end

function ZomboidServer:set_hide_players_behind_you(v)
    self.HidePlayersBehindYou = v
end

function ZomboidServer:get_hide_players_behind_you()
    return self.HidePlayersBehindYou
end

function ZomboidServer:set_pvp_melee_damage_modifier(v)
    self.PVPMeleeDamageModifier = v
end

function ZomboidServer:get_pvp_melee_damage_modifier()
    return self.PVPMeleeDamageModifier
end

function ZomboidServer:set_pvp_firearm_damage_modifier(v)
    self.PVPFirearmDamageModifier = v
end

function ZomboidServer:get_pvp_firearm_damage_modifier()
    return self.PVPFirearmDamageModifier
end

function ZomboidServer:set_car_engine_attraction_modifier(v)
    self.CarEngineAttractionModifier = v
end

function ZomboidServer:get_car_engine_attraction_modifier()
    return self.CarEngineAttractionModifier
end

function ZomboidServer:set_player_bump_player(v)
    self.PlayerBumpPlayer = v
end

function ZomboidServer:get_player_bump_player()
    return self.PlayerBumpPlayer
end

function ZomboidServer:set_map_remote_player_visibility(v)
    self.MapRemotePlayerVisibility = v
end

function ZomboidServer:get_map_remote_player_visibility()
    return self.MapRemotePlayerVisibility
end

function ZomboidServer:set_backups_count(v)
    self.BackupsCount = v
end

function ZomboidServer:get_backups_count()
    return self.BackupsCount
end

function ZomboidServer:set_backups_on_start(v)
    self.BackupsOnStart = v
end

function ZomboidServer:get_backups_on_start()
    return self.BackupsOnStart
end

function ZomboidServer:set_backups_on_version_change(v)
    self.BackupsOnVersionChange = v
end

function ZomboidServer:get_backups_on_version_change()
    return self.BackupsOnVersionChange
end

function ZomboidServer:set_backups_period(v)
    self.BackupsPeriod = v
end

function ZomboidServer:get_backups_period()
    return self.BackupsPeriod
end

function ZomboidServer:set_anti_cheat_protection_type_1(v)
    self.anti_cheat_protection_type_1 = v
end

function ZomboidServer:get_anti_cheat_protection_type_1()
    return self.anti_cheat_protection_type_1
end

function ZomboidServer:set_anti_cheat_protection_type_2(v)
    self.anti_cheat_protection_type_2 = v
end

function ZomboidServer:get_anti_cheat_protection_type_2()
    return self.anti_cheat_protection_type_2
end

function ZomboidServer:set_anti_cheat_protection_type_3(v)
    self.anti_cheat_protection_type_3 = v
end

function ZomboidServer:get_anti_cheat_protection_type_3()
    return self.anti_cheat_protection_type_3
end

function ZomboidServer:set_anti_cheat_protection_type_4(v)
    self.anti_cheat_protection_type_4 = v
end

function ZomboidServer:get_anti_cheat_protection_type_4()
    return self.anti_cheat_protection_type_4
end

function ZomboidServer:set_anti_cheat_protection_type_5(v)
    self.anti_cheat_protection_type_5 = v
end

function ZomboidServer:get_anti_cheat_protection_type_5()
    return self.anti_cheat_protection_type_5
end

function ZomboidServer:set_anti_cheat_protection_type_6(v)
    self.anti_cheat_protection_type_6 = v
end

function ZomboidServer:get_anti_cheat_protection_type_6()
    return self.anti_cheat_protection_type_6
end

function ZomboidServer:set_anti_cheat_protection_type_7(v)
    self.anti_cheat_protection_type_7 = v
end

function ZomboidServer:get_anti_cheat_protection_type_7()
    return self.anti_cheat_protection_type_7
end

function ZomboidServer:set_anti_cheat_protection_type_8(v)
    self.anti_cheat_protection_type_8 = v
end

function ZomboidServer:get_anti_cheat_protection_type_8()
    return self.anti_cheat_protection_type_8
end

function ZomboidServer:set_anti_cheat_protection_type_9(v)
    self.anti_cheat_protection_type_9 = v
end

function ZomboidServer:get_anti_cheat_protection_type_9()
    return self.anti_cheat_protection_type_9
end

function ZomboidServer:set_anti_cheat_protection_type_10(v)
    self.anti_cheat_protection_type_10 = v
end

function ZomboidServer:get_anti_cheat_protection_type_10()
    return self.anti_cheat_protection_type_10
end

function ZomboidServer:set_anti_cheat_protection_type_11(v)
    self.anti_cheat_protection_type_11 = v
end

function ZomboidServer:get_anti_cheat_protection_type_11()
    return self.anti_cheat_protection_type_11
end

function ZomboidServer:set_anti_cheat_protection_type_12(v)
    self.anti_cheat_protection_type_12 = v
end

function ZomboidServer:get_anti_cheat_protection_type_12()
    return self.anti_cheat_protection_type_12
end

function ZomboidServer:set_anti_cheat_protection_type_13(v)
    self.anti_cheat_protection_type_13 = v
end

function ZomboidServer:get_anti_cheat_protection_type_13()
    return self.anti_cheat_protection_type_13
end

function ZomboidServer:set_anti_cheat_protection_type_14(v)
    self.anti_cheat_protection_type_14 = v
end

function ZomboidServer:get_anti_cheat_protection_type_14()
    return self.anti_cheat_protection_type_14
end

function ZomboidServer:set_anti_cheat_protection_type_15(v)
    self.anti_cheat_protection_type_15 = v
end

function ZomboidServer:get_anti_cheat_protection_type_15()
    return self.anti_cheat_protection_type_15
end

function ZomboidServer:set_anti_cheat_protection_type_16(v)
    self.anti_cheat_protection_type_16 = v
end

function ZomboidServer:get_anti_cheat_protection_type_16()
    return self.anti_cheat_protection_type_16
end

function ZomboidServer:set_anti_cheat_protection_type_17(v)
    self.anti_cheat_protection_type_17 = v
end

function ZomboidServer:get_anti_cheat_protection_type_17()
    return self.anti_cheat_protection_type_17
end

function ZomboidServer:set_anti_cheat_protection_type_18(v)
    self.anti_cheat_protection_type_18 = v
end

function ZomboidServer:get_anti_cheat_protection_type_18()
    return self.anti_cheat_protection_type_18
end

function ZomboidServer:set_anti_cheat_protection_type_19(v)
    self.anti_cheat_protection_type_19 = v
end

function ZomboidServer:get_anti_cheat_protection_type_19()
    return self.anti_cheat_protection_type_19
end

function ZomboidServer:set_anti_cheat_protection_type_20(v)
    self.anti_cheat_protection_type_20 = v
end

function ZomboidServer:get_anti_cheat_protection_type_20()
    return self.anti_cheat_protection_type_20
end

function ZomboidServer:set_anti_cheat_protection_type_21(v)
    self.anti_cheat_protection_type_21 = v
end

function ZomboidServer:get_anti_cheat_protection_type_21()
    return self.anti_cheat_protection_type_21
end

function ZomboidServer:set_anti_cheat_protection_type_22(v)
    self.anti_cheat_protection_type_22 = v
end

function ZomboidServer:get_anti_cheat_protection_type_22()
    return self.anti_cheat_protection_type_22
end

function ZomboidServer:set_anti_cheat_protection_type_23(v)
    self.anti_cheat_protection_type_23 = v
end

function ZomboidServer:get_anti_cheat_protection_type_23()
    return self.anti_cheat_protection_type_23
end

function ZomboidServer:set_anti_cheat_protection_type_24(v)
    self.anti_cheat_protection_type_24 = v
end

function ZomboidServer:get_anti_cheat_protection_type_24()
    return self.anti_cheat_protection_type_24
end

function ZomboidServer:set_anti_cheat_protection_type_2_threshold_multiplier(v)
    self.anti_cheat_protection_type_2_threshold_multiplier = v
end

function ZomboidServer:get_anti_cheat_protection_type_2_threshold_multiplier()
    return self.anti_cheat_protection_type_2_threshold_multiplier
end

function ZomboidServer:set_anti_cheat_protection_type_3_threshold_multiplier(v)
    self.anti_cheat_protection_type_3_threshold_multiplier = v
end

function ZomboidServer:get_anti_cheat_protection_type_3_threshold_multiplier()
    return self.anti_cheat_protection_type_3_threshold_multiplier
end

function ZomboidServer:set_anti_cheat_protection_type_4_threshold_multiplier(v)
    self.anti_cheat_protection_type_4_threshold_multiplier = v
end

function ZomboidServer:get_anti_cheat_protection_type_4_threshold_multiplier()
    return self.anti_cheat_protection_type_4_threshold_multiplier
end

function ZomboidServer:set_anti_cheat_protection_type_9_threshold_multiplier(v)
    self.anti_cheat_protection_type_9_threshold_multiplier = v
end

function ZomboidServer:get_anti_cheat_protection_type_9_threshold_multiplier()
    return self.anti_cheat_protection_type_9_threshold_multiplier
end

function ZomboidServer:set_anti_cheat_protection_type_15_threshold_multiplier(v)
    self.anti_cheat_protection_type_15_threshold_multiplier = v
end

function ZomboidServer:get_anti_cheat_protection_type_15_threshold_multiplier()
    return self.anti_cheat_protection_type_15_threshold_multiplier
end

function ZomboidServer:set_anti_cheat_protection_type_20_threshold_multiplier(v)
    self.anti_cheat_protection_type_20_threshold_multiplier = v
end

function ZomboidServer:get_anti_cheat_protection_type_20_threshold_multiplier()
    return self.anti_cheat_protection_type_20_threshold_multiplier
end

function ZomboidServer:set_anti_cheat_protection_type_22_threshold_multiplier(v)
    self.anti_cheat_protection_type_22_threshold_multiplier = v
end

function ZomboidServer:get_anti_cheat_protection_type_22_threshold_multiplier()
    return self.anti_cheat_protection_type_22_threshold_multiplier
end

function ZomboidServer:set_anti_cheat_protection_type_24_threshold_multiplier(v)
    self.anti_cheat_protection_type_24ThresholdMultiplier = v
end

function ZomboidServer:get_anti_cheat_protection_type_24_threshold_multiplier()
    return self.anti_cheat_protection_type_24ThresholdMultiplier
end

ZomboidServerInterface = {
    load_file = function(selected_file)
        if not file_exists(selected_file) then
            return false
        else
            local data_file = io.open(selected_file, 'r')
            if not data_file then
                return false
            end
            local line = data_file:read('*line')
            local extract_value = false
            while line do
                extract_value = false
                local key = ''
                local value = ''
                local first_char = ''
                for i = 1, string.len(line) do
                    local char = string.sub(line, i, i)
                    if first_char == '' and char ~= ' ' then
                        first_char = char
                    end
                    if first_char == '#' then
                        break
                    elseif char == '=' and first_char ~= '' then
                        extract_value = true
                    elseif char == '=' and first_char == '' then
                        break
                    elseif not extract_value then
                        key = key .. char
                    elseif extract_value then
                        value = value .. char
                    end
                end
                if key ~= '' and extract_value then
                    if string.lower(value) == 'false' then
                        value = false
                    elseif string.lower(value) == 'true' then
                        value = true
                    end
                    if ZomboidServerInterface.instance[key] ~= nil then
                        ZomboidServerInterface.instance[key] = value
                    end
                end
                line = data_file:read('*line')
            end
            data_file:close()
        end
        return true
    end,
    display_order =
    {
        'LoadFile',
        'ReloadConfig',

        -- Primary Tab Container
        'PrimaryTab',

        'DetailsTab',
        --Details
        'Map',
        'SpawnPoint',
        'DefaultPort',
        'PublicName',
        'PublicDescription',
        'Public',
        'Password',
        'PauseEmpty',
        'ResetID',

        'SteamTab',
        --Steam
        'UDPPort',
        'MaxAccountsPerUser',
        'SteamScoreboard',
        'SteamVAC',
        'SteamWorkshopLabel',
        'WorkshopItems',
        'Mods',

        'BackupsTab',
        --Backups
        'BackupsCount',
        'BackupsOnStart',
        'BackupsOnVersionChange',
        'BackupsPeriod',



        'PlayersTab',
        '_PlayerConfig',
        --Players
        'MaxPlayers',
        'Open',
        'AutoCreateUserInWhiteList',
        'DropOffWhiteListAfterDeath',
        'DisplayUserName',
        'ShowFirstAndLastName',
        'SpawnItems',
        'PingLimit',
        'ServerPlayerID',
        'SleepAllowed',
        'SleepNeeded',
        'PlayerRespawnWithSelf',
        'PlayerRespawnWithOther',
        'RemovePlayerCorpsesOnCorpseRemoval',
        'TrashDeleteAll',
        'PVPMeleeWhileHitReaction',
        'MouseOverToSeeDisplayName',
        'HidePlayersBehindYou',
        'PlayerBumpPlayer',
        'MapRemotePlayerVisibility',
        'AllowCoop',
        'KnockedDownAllowed',
        'SneakModeHideFromOtherPlayers',
        'AnnounceDeath',

        'AdminTab',
        --Admin
        'ClientCommandFilter',
        'ClientActionLogs',
        'PerkLogs',
        'DisableRadioStaff',
        'DisableRadioAdmin',
        'DisableRadioGM',
        'DisableRadioOverseer',
        'DisableRadioModerator',
        'DisableRadioInvisible',
        'KickFastPlayers',
        'DenyLoginOnOverloadedServer',
        'LoginQueueEnabled',
        'LoginQueueConnectTimeout',
        'server_browser_announced_ip',
        'BanKickGlobalSound',
        '_RCONLABEL',
        'RCONPort',
        'RCONPassword',

        --Fire
        'NoFire',

        'PVPTab',
        --PVP
        'PVP',
        'SafetySystem',
        'ShowSafety',
        'SafetyToggleTimer',
        'SafetyCooldownTimer',
        'PVPMeleeDamageModifier',
        'PVPFirearmDamageModifier',

        'LootTab',
        --Loot
        'HoursForLootRespawn',
        'MaxItemsForLootRespawn',
        'ConstructionPreventsLootRespawn',
        'ItemNumbersLimitPerContainer',

        'FactionTab',
        --Faction
        'Faction',
        'FactionDaySurvivedToCreate',
        'FactionPlayersRequiredForTag',

        'SafehouseTab',
        --Safehouse
        'AdminSafehouse',
        'PlayerSafehouse',
        'SafehouseAllowTrepass',
        'SafehouseAllowFire',
        'SafehouseAllowLoot',
        'SafehouseAllowRespawn',
        'SafehouseDaySurvivedToClaim',
        'SafeHouseRemovalTime',
        'DisableSafehouseWhenPlayerConnected',
        'SafehouseAllowNonResidential',

        'CommsTab',
        'ChatTab',
        --Chat
        'GlobalChat',
        'ChatStreams',
        'ServerWelcomeMessage',

        'VoiceTab',
        --Voice
        'VoiceEnable',
        'VoiceMinDistance',
        'VoiceMaxDistance',
        'Voice3D',

        'DiscordTab',
        --Discord
        'DiscordEnable',
        'DiscordToken',
        'DiscordChannel',
        'DiscordChannelID',


        --Rcon

        --UPnP
        'UPnP',

        'OtherTab',
        'MiscTab',
        --Other
        'DoLuaChecksum',
        'AllowDestructionBySledgehammer',
        'SledgehammerOnlyInSafehouse',
        'MinutesPerPage',
        'SaveWorldEveryMinutes',
        'FastForwardMultiplier',
        'BloodSplatLifespanDays',
        'AllowNonAsciiUsername',

        --Vehicles
        'SpeedLimit',
        'CarEngineAttractionModifier',



        'AntiCheatTab',
        --AntiCheat
        'AntiCheatProtectionType1',
        'AntiCheatProtectionType2',
        'AntiCheatProtectionType2ThresholdMultiplier',
        'AntiCheatProtectionType3',
        'AntiCheatProtectionType3ThresholdMultiplier',
        'AntiCheatProtectionType4',
        'AntiCheatProtectionType4ThresholdMultiplier',
        'AntiCheatProtectionType5',
        'AntiCheatProtectionType6',
        'AntiCheatProtectionType7',
        'AntiCheatProtectionType8',
        'AntiCheatProtectionType9',
        'AntiCheatProtectionType9ThresholdMultiplier',
        'AntiCheatProtectionType10',
        'AntiCheatProtectionType11',
        'AntiCheatProtectionType12',
        'AntiCheatProtectionType13',
        'AntiCheatProtectionType14',
        'AntiCheatProtectionType15',
        'AntiCheatProtectionType15ThresholdMultiplier',
        'AntiCheatProtectionType16',
        'AntiCheatProtectionType17',
        'AntiCheatProtectionType18',
        'AntiCheatProtectionType19',
        'AntiCheatProtectionType20',
        'AntiCheatProtectionType20ThresholdMultiplier',
        'AntiCheatProtectionType21',
        'AntiCheatProtectionType22',
        'AntiCheatProtectionType22ThresholdMultiplier',
        'AntiCheatProtectionType23',
        'AntiCheatProtectionType24',
        'AntiCheatProtectionType24ThresholdMultiplier',
    },
    instance = ZomboidServer:new(),
    schema =
    {
        ['LoadFile'] = {
            description = 'Load Configuration File',
            type = FileBrowse,
            default = '',
            value = '',
            last_loaded = '',
            setter = function(selected_file)
                local _this = ZomboidServerInterface.schema.LoadFile
                if not file_exists(selected_file) then
                    return
                end
                if selected_file == _this.last_loaded then
                    return
                end
                if ZomboidServerInterface.load_file(selected_file) then
                    _this.last_loaded = selected_file
                    _this.value = selected_file
                else
                    _this.value = ''
                end
            end,
            getter = function()
                local _this = ZomboidServerInterface.schema.LoadFile
                return _this.value
            end
        },
        ['ReloadConfig'] = {
            description = 'Reload Configuration',
            default = '',
            type = Button,
            action = function()
                if ZomboidServerInterface.schema.LoadFile.last_loaded then
                    if ZomboidServerInterface.load_file(ZomboidServerInterface.schema.LoadFile.last_loaded) then
                        ZomboidServerInterface.schema.LoadFile.value = ZomboidServerInterface.schema.LoadFile
                        .last_loaded
                    else
                        ZomboidServerInterface.schema.LoadFile.value = ''
                    end
                end
            end,
            getter = function() return 'Reload Configuration' end
        },
        ['PrimaryTab'] = {
            type = TabContainer,
            tab_height = 13,
            schema = {
                ['DetailsTab'] = {
                    type = Tab,
                    description = 'Details',
                    schema = {
                        ['SpawnPoint'] = {
                            description = 'Spawn Point',
                            default = '0,0,0',
                            type = String,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_spawn_point(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_spawn_point()
                            end
                        },
                        ['DefaultPort'] = {
                            description = 'Default Port',
                            default = 16262,
                            type = IntegerRange,
                            minimum = 0,
                            maximum = 65535,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_default_port(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_default_port()
                            end
                        },
                        ['PublicName'] = {
                            description = 'Public Name',
                            default = 'Project Zomboid Server',
                            type = String,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_public_name(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_public_name()
                            end
                        },
                        ['PublicDescription'] = {
                            description = 'Public Description',
                            default = '[Redacted]',
                            type = String,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_public_description(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_public_description()
                            end
                        },
                        ['Public'] = {
                            description = 'Public',
                            default = true,
                            type = Boolean,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_public(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_public()
                            end
                        },
                        ['Password'] = {
                            description = 'Password',
                            default = 'simonsfault',
                            type = String,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_password(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_password()
                            end
                        },
                        ['PauseEmpty'] = {
                            description = 'Pause Empty',
                            default = true,
                            type = Boolean,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_pause_empty(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_pause_empty()
                            end
                        },
                        ['ResetID'] = {
                            description = 'Reset ID',
                            default = 65790200,
                            type = IntegerRange,
                            minimum = 0,
                            maximum = 2147483647,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_reset_id(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_reset_id()
                            end
                        },
                        ['Map'] = {
                            description = 'Map',
                            default = 'Muldraugh, KY',
                            type = String,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_map(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_map()
                            end
                        },
                    }
                },
                ['SteamTab'] = {
                    type = Tab,
                    description = 'Steam',
                    schema = {
                        ['UDPPort'] = {
                            description = 'UDP Port',
                            default = 8767,
                            type = IntegerRange,
                            minimum = 0,
                            maximum = 65535,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_udp_port(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_udp_port()
                            end
                        },
                        ['MaxAccountsPerUser'] = {
                            description = 'Max Accounts Per User',
                            default = 0,
                            type = IntegerRange,
                            minimum = 0,
                            maximum = 2147483647,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_max_accounts_per_user(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_max_accounts_per_user()
                            end
                        },
                        ['SteamScoreboard'] = {
                            description = 'Steam Scoreboard',
                            default = true,
                            type = Boolean,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_steam_scoreboard(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_steam_scoreboard()
                            end
                        },
                        ['SteamVAC'] = {
                            description = 'Steam VAC',
                            default = true,
                            type = Boolean,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_steam_vac(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_steam_vac()
                            end
                        },
                        ['SteamWorkshopLabel'] = {
                            type = Label,
                            description = 'Steam Workshop Settings',
                        },
                        ['WorkshopItems'] = {
                            description = 'Workshop Items',
                            default = '',
                            type = String,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_workshop_items(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_workshop_items()
                            end
                        },
                        ['Mods'] = {
                            description = 'Mods',
                            default = '',
                            type = String,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_mods(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_mods()
                            end
                        },
                    }
                },
                ['BackupsTab'] = {
                    type = Tab,
                    description = 'Backups',
                    schema = {
                        ['BackupsCount'] = {
                            description = 'Backups Count',
                            default = 5,
                            type = IntegerRange,
                            minimum = 1,
                            maximum = 300,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_backups_count(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_backups_count()
                            end
                        },
                        ['BackupsOnStart'] = {
                            description = 'Backups On Start',
                            default = true,
                            type = Boolean,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_backups_on_start(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_backups_on_start()
                            end
                        },
                        ['BackupsOnVersionChange'] = {
                            description = 'Backups On Version Change',
                            default = true,
                            type = Boolean,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_backups_on_version_change(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_backups_on_version_change()
                            end
                        },
                        ['BackupsPeriod'] = {
                            description = 'Backups Period',
                            default = 0,
                            type = IntegerRange,
                            minimum = 0,
                            maximum = 1500,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_backups_period(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_backups_period()
                            end
                        },
                    }
                },
                ['PlayersTab'] = {
                    type = Tab,
                    description = 'Players',
                    schema = {
                        ['_PlayersTabContainer'] = {
                            type = TabContainer,
                            tab_height = 11,
                            schema = {
                                ['_PlayerConfig'] = {
                                    type = Tab,
                                    description = 'Player Configuration',
                                    schema = {
                                        ['PingLimit'] = {
                                            description = 'Ping Limit (milliseconds)',
                                            default = 100,
                                            type = IntegerRange,
                                            minimum = 100,
                                            maximum = 2147483647,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_ping_limit(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_ping_limit()
                                            end
                                        },
                                        ['MaxPlayers'] = {
                                            description = 'Max Players',
                                            default = 32,
                                            type = IntegerRange,
                                            minimum = 1,
                                            maximum = 100,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_max_players(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_max_players()
                                            end
                                        },
                                        ['Open'] = {
                                            description = 'Open',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_open(v)
                                            end,
                                            getter = function()
                                                local v = ZomboidServerInterface.instance:get_open()
                                                if type(v) == 'string' then
                                                    if v == 'true' then
                                                        v = true
                                                    else
                                                        v = false
                                                    end
                                                end
                                                return v
                                            end
                                        },
                                        ['AutoCreateUserInWhiteList'] = {
                                            description = 'Auto Create User In Whitelist',
                                            default = false,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_auto_create_user_in_whitelist(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_auto_create_user_in_whitelist()
                                            end
                                        },
                                        ['DropOffWhiteListAfterDeath'] = {
                                            description = 'Drop Off White List After Death',
                                            default = false,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_drop_off_whitelist_after_death(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_drop_off_whitelist_after_death()
                                            end
                                        },
                                        ['DisplayUserName'] = {
                                            description = 'Display User Name',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_display_user_name(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_display_user_name()
                                            end
                                        },
                                        ['ShowFirstAndLastName'] = {
                                            description = 'Show First And Last Name',
                                            default = false,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_show_first_and_last_name(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_show_first_and_last_name()
                                            end
                                        },
                                        ['SpawnItems'] = {
                                            description = 'Spawn Items',
                                            default = '',
                                            type = String,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_spawn_items(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_spawn_items()
                                            end
                                        },
                                        ['ServerPlayerID'] = {
                                            description = 'Server Player ID',
                                            default = 514776408,
                                            type = Integer,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_server_player_id(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_server_player_id()
                                            end
                                        },
                                        ['SleepAllowed'] = {
                                            description = 'Sleep Allowed',
                                            default = false,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_sleep_allowed(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_sleep_allowed()
                                            end
                                        },
                                        ['PlayerRespawnWithSelf'] = {
                                            description = 'Player Respawn With Self',
                                            default = false,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_player_respawn_with_self(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_player_respawn_with_self()
                                            end
                                        },
                                        ['PlayerRespawnWithOther'] = {
                                            description = 'Player Respawn With Other',
                                            default = false,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_player_respawn_with_other(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_player_respawn_with_other()
                                            end
                                        },
                                        ['RemovePlayerCorpsesOnCorpseRemoval'] = {
                                            description = 'Remove Player Corpses On Corpse Removal',
                                            default = false,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_remove_player_corpses_on_corpse_removal(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_remove_player_corpses_on_corpse_removal()
                                            end
                                        },
                                        ['TrashDeleteAll'] = {
                                            description = 'Trash Delete All',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_trash_delete_all(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_trash_delete_all()
                                            end
                                        },
                                        ['PVPMeleeWhileHitReaction'] = {
                                            description = 'PVP Melee While Hit Reaction',
                                            default = false,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_pvp_melee_while_hit_reaction(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_pvp_melee_while_hit_reaction()
                                            end
                                        },
                                        ['MouseOverToSeeDisplayName'] = {
                                            description = 'Mouse Over To See Display Name',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_mouse_over_to_see_display_name(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_mouse_over_to_see_display_name()
                                            end
                                        },
                                        ['HidePlayersBehindYou'] = {
                                            description = 'Hide Players Behind You',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_hide_players_behind_you(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_hide_players_behind_you()
                                            end
                                        },
                                        ['PlayerBumpPlayer'] = {
                                            description = 'Player Bump Player',
                                            default = false,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_player_bump_player(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_player_bump_player()
                                            end
                                        },
                                        ['MapRemotePlayerVisibility'] = {
                                            description = 'Map Remote Player Visibility',
                                            default = 1,
                                            type = IntegerRange,
                                            minimum = 1,
                                            maximum = 3,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_map_remote_player_visibility(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_map_remote_player_visibility()
                                            end
                                        },
                                        ['AllowCoop'] = {
                                            description = 'Allow Coop',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_allow_cooperative_play(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_allow_cooperative_play()
                                            end
                                        },
                                        ['KnockedDownAllowed'] = {
                                            description = 'Knocked Down Allowed',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_knocked_down_allowed(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_knocked_down_allowed()
                                            end
                                        },
                                        ['SneakModeHideFromOtherPlayers'] = {
                                            description = 'Sneak Mode Hide From Other Players',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_sneak_mode_hide_from_other_players(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_sneak_mode_hide_from_other_players()
                                            end
                                        },
                                        ['AnnounceDeath'] = {
                                            description = 'Announce Death',
                                            default = false,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_announce_death(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_announce_death()
                                            end
                                        },
                                    }
                                },
                                ['PVPTab'] = {
                                    type = Tab,
                                    description = 'PVP Configuration',
                                    schema = {
                                        ['PVP'] = {
                                            description = 'PVP',
                                            default = true,
                                            type = Boolean,
                                            value = true,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_pvp(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_pvp()
                                            end
                                        },
                                        ['SafetySystem'] = {
                                            description = 'Safety System',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_safety_system(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_safety_system()
                                            end
                                        },
                                        ['ShowSafety'] = {
                                            description = 'Show Safety',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_show_safety(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_show_safety()
                                            end
                                        },
                                        ['SafetyToggleTimer'] = {
                                            description = 'Safety Toggle Timer',
                                            default = 2,
                                            type = IntegerRange,
                                            minimum = 0,
                                            maximum = 1000,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_safety_toggle_timer(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_safety_toggle_timer()
                                            end
                                        },
                                        ['SafetyCooldownTimer'] = {
                                            description = 'Safety Cooldown Timer',
                                            default = 3,
                                            type = IntegerRange,
                                            minimum = 0,
                                            maximum = 1000,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_safety_cooldown_timer(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_safety_cooldown_timer()
                                            end
                                        },
                                        ['PVPMeleeDamageModifier'] = {
                                            description = 'PVP Melee Damage Modifier (Decimal)',
                                            default = 30.0,
                                            type = FloatRange,
                                            minimum = 0.0,
                                            maximum = 500.0,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_pvp_melee_damage_modifier(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_pvp_melee_damage_modifier()
                                            end
                                        },
                                        ['PVPFirearmDamageModifier'] = {
                                            description = 'PVP Firearm Damage Modifier',
                                            default = 50.0,
                                            type = FloatRange,
                                            minimum = 0.0,
                                            maximum = 500.0,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_pvp_firearm_damage_modifier(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_pvp_firearm_damage_modifier()
                                            end
                                        },
                                    }
                                }
                            },
                        },
                    }
                },
                ['AdminTab'] = {
                    type = Tab,
                    description = 'Admin',
                    schema = {
                        ['ClientCommandFilter'] = {
                            description = 'Client Command Filter',
                            default = '-vehicle.*;+vehicle.damageWindow;+vehicle.fixPart;+vehicle.installPart;+vehicle.uninstallPart',
                            type = String,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_client_command_filter(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_client_command_filter()
                            end
                        },
                        ['ClientActionLogs'] = {
                            description = 'Client Action Logs',
                            default = 'ISEnterVehicle;ISExitVehicle;ISTakeEngineParts;',
                            type = String,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_client_action_logs(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_client_action_logs()
                            end
                        },
                        ['PerkLogs'] = {
                            description = 'Perk Logs',
                            default = true,
                            type = Boolean,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_perk_logs(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_perk_logs()
                            end
                        },
                        ['DisableRadioStaff'] = {
                            description = 'Disable Radio Staff',
                            default = false,
                            type = Boolean,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_disable_radio_staff(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_disable_radio_staff()
                            end
                        },
                        ['DisableRadioAdmin'] = {
                            description = 'Disable Radio Admin',
                            default = true,
                            type = Boolean,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_disable_radio_admin(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_disable_radio_admin()
                            end
                        },
                        ['DisableRadioGM'] = {
                            description = 'Disable Radio GM',
                            default = true,
                            type = Boolean,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_disable_radio_gm(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_disable_radio_gm()
                            end
                        },
                        ['DisableRadioOverseer'] = {
                            description = 'Disable Radio Overseer',
                            default = false,
                            type = Boolean,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_disable_radio_overseer(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_disable_radio_overseer()
                            end
                        },
                        ['DisableRadioModerator'] = {
                            description = 'Disable Radio Moderator',
                            default = false,
                            type = Boolean,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_disable_radio_moderator(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_disable_radio_moderator()
                            end
                        },
                        ['DisableRadioInvisible'] = {
                            description = 'Disable Radio Invisible',
                            default = true,
                            type = Boolean,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_disable_radio_invisible(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_disable_radio_invisible()
                            end
                        },
                        ['KickFastPlayers'] = {
                            description = 'Kick Fast Players',
                            default = false,
                            type = Boolean,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_kick_fast_players(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_kick_fast_players()
                            end
                        },
                        ['DenyLoginOnOverloadedServer'] = {
                            description = 'Deny Login On Overloaded Server',
                            default = true,
                            type = Boolean,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_deny_login_on_overloaded_server(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_deny_login_on_overloaded_server()
                            end
                        },
                        ['LoginQueueEnabled'] = {
                            description = 'Login Queue Enabled',
                            default = false,
                            type = Boolean,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_login_queue_enabled(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_login_queue_enabled()
                            end
                        },
                        ['LoginQueueConnectTimeout'] = {
                            description = 'Login Queue Connect Timeout',
                            default = 60,
                            type = IntegerRange,
                            minimum = 20,
                            maximum = 1200,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_login_queue_connect_timeout(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_login_queue_connect_timeout()
                            end
                        },
                        ['server_browser_announced_ip'] = {
                            description = 'Server Browser Announced IP',
                            default = '',
                            type = String,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_server_browser_announced_ip(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_server_browser_announced_ip()
                            end
                        },
                        ['BanKickGlobalSound'] = {
                            description = 'Ban Kick Global Sound',
                            default = true,
                            type = Boolean,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_ban_kick_global_sound(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_ban_kick_global_sound()
                            end
                        },
                        ['_RCONLABEL'] = {
                            description = 'Remote Console',
                            type = Label
                        },
                        ['RCONPort'] = {
                            description = 'Remote Console Port',
                            default = 27015,
                            type = IntegerRange,
                            minimum = 0,
                            maximum = 65535,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_rcon_port(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_rcon_port()
                            end
                        },
                        ['RCONPassword'] = {
                            description = 'Remote Console Password',
                            default = '61yejbpn',
                            type = String,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_rcon_password(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_rcon_password()
                            end
                        },
                    },
                },
                ['SafehouseTab'] = {
                    type = Tab,
                    description = 'Safehouse',
                    schema = {
                        ['AdminSafehouse'] = {
                            description = 'Admin Safehouse',
                            default = false,
                            type = Boolean,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_admin_safehouse(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_admin_safehouse()
                            end
                        },
                        ['PlayerSafehouse'] = {
                            description = 'Player Safehouse',
                            default = false,
                            type = Boolean,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_player_safehouse(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_player_safehouse()
                            end
                        },
                        ['SafehouseAllowTrepass'] = {
                            description = 'Safehouse Allow Trespass',
                            default = true,
                            type = Boolean,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_safehouse_allow_trespass(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_safehouse_allow_trespass()
                            end
                        },
                        ['SafehouseAllowFire'] = {
                            description = 'Safehouse Allow Fire',
                            default = true,
                            type = Boolean,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_safehouse_allow_fire(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_safehouse_allow_fire()
                            end
                        },
                        ['SafehouseAllowLoot'] = {
                            description = 'Safehouse Allow Loot',
                            default = true,
                            type = Boolean,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_safehouse_allow_loot(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_safehouse_allow_loot()
                            end
                        },
                        ['SafehouseAllowRespawn'] = {
                            description = 'Safehouse Allow Respawn',
                            default = false,
                            type = Boolean,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_safehouse_allow_respawn(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_safehouse_allow_respawn()
                            end
                        },
                        ['SafehouseDaySurvivedToClaim'] = {
                            description = 'Safehouse Day Survived To Claim',
                            default = 0,
                            type = IntegerRange,
                            minimum = 0,
                            maximum = 2147483647,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_safehouse_day_survived_to_claim(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_safehouse_day_survived_to_claim()
                            end
                        },
                        ['SafeHouseRemovalTime'] = {
                            description = 'SafeHouse Removal Time',
                            default = '144',
                            type = IntegerRange,
                            minimum = 0,
                            maximum = 2147483647,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_safehouse_removal_time(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_safehouse_removal_time()
                            end
                        },
                        ['DisableSafehouseWhenPlayerConnected'] = {
                            description = 'Disable Safehouse When Player Connected',
                            default = false,
                            type = Boolean,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_disable_safehouse_when_player_connected(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_disable_safehouse_when_player_connected()
                            end
                        },
                        ['SafehouseAllowNonResidential'] = {
                            description = 'Safehouse Allow Non-Residential',
                            default = false,
                            type = Boolean,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_safehouse_allow_non_residential(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_safehouse_allow_non_residential()
                            end
                        },
                    }
                },
                ['CommsTab'] = {
                    type = Tab,
                    description = 'Comms',
                    schema = {
                        ['_CommsTabContainer'] =
                        {
                            type = TabContainer,
                            tab_height = 10,
                            schema = {
                                ['VoiceTab'] = {
                                    type = Tab,
                                    description = 'Voice',
                                    schema = {
                                        ['VoiceEnable'] = {
                                            description = 'Voice Enabled',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_voice_enabled(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_voice_enabled()
                                            end
                                        },
                                        ['VoiceMinDistance'] = {
                                            description = 'Voice Min Distance (Decimal, tile distance)',
                                            default = 10.0,
                                            type = FloatRange,
                                            minimum = 0.0,
                                            maximum = 100000.00,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_voice_min_distance(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_voice_min_distance()
                                            end
                                        },
                                        ['VoiceMaxDistance'] = {
                                            description = 'Voice Max Distance',
                                            default = 100.00,
                                            type = FloatRange,
                                            minimum = 0.0,
                                            maximum = 100000.00,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_voice_max_distance(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_voice_max_distance()
                                            end
                                        },
                                        ['Voice3D'] = {
                                            description = 'Direction audio for VOIP',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_voice_3d(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_voice_3d()
                                            end
                                        },
                                    },
                                },
                                ['ChatTab'] = {
                                    type = Tab,
                                    description = 'Chat',
                                    schema = {
                                        ['GlobalChat'] = {
                                            description = 'Global Chat',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_global_chat(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_global_chat()
                                            end
                                        },
                                        ['ChatStreams'] = {
                                            description = 'Chat Streams',
                                            default = 's,r,a,w,y,sh,f,all',
                                            values = {
                                                {text = 'Talk to people on the screen, including the dead', value = true, flag = 's'},
                                                {text = 'Transcript of radio broadcasts', value = true, flag = 'r'},
                                                {text = 'Talk to an admin', value = true, flag = 'a'},
                                                {text = 'Whisper to someone, distance doesn\'t matter', value = true, flag = 'w'},
                                                {text = 'Yell to people on screen and a bit further away, also attracts zombies', value = true, flag = 'y'},
                                                {text = 'Talk to people with whom you share a safehouse', value = true, flag = 'sh'},
                                                {text = 'Talk to people in your faction', value = true, flag = 'f'},
                                                {text = 'Safely talk to everyone online', value = true, flag = 'all'}
                                            },
                                            type = CheckList,
                                            setter = function(table)
                                                local chatstream_string = ''
                                                local first = true
                                                local values = ZomboidServerInterface.schema.PrimaryTab.schema.CommsTab.schema._CommsTabContainer.schema.ChatTab.schema.ChatStreams.values

                                                for i = 1, #values do
                                                    if values[i].text == table.text then
                                                        ZomboidServerInterface.schema.PrimaryTab.schema.CommsTab.schema._CommsTabContainer.schema.ChatTab.schema.ChatStreams.values[i].value = table.value
                                                    end
                                                    if values[i].value then
                                                        if not first then
                                                            chatstream_string = chatstream_string .. ','
                                                        end
                                                        chatstream_string = chatstream_string .. values[i].flag
                                                        first = false
                                                    end
                                                end
                                                ZomboidServerInterface.instance:set_chat_streams(chatstream_string)
                                            end,
                                            getter = function()
                                                local values = ZomboidServerInterface.schema.PrimaryTab.schema.CommsTab.schema._CommsTabContainer.schema.ChatTab.schema.ChatStreams.values
                                                local chatstream_string = ZomboidServerInterface.instance:get_chat_streams()
                                                local flag_table = {}
                                                local current_component = ''
                                                for i = 1, string.len(chatstream_string) do
                                                    local char = string.sub(chatstream_string, i, i)
                                                    if char == ',' then
                                                        flag_table[#flag_table + 1] = current_component
                                                        current_component = ''
                                                    else
                                                        current_component = current_component .. char
                                                    end
                                                end
                                                if string.len(current_component) > 0 then
                                                    flag_table[#flag_table + 1] = current_component
                                                end
                                                for i = 1, #values do
                                                    ZomboidServerInterface.schema.PrimaryTab.schema.CommsTab.schema._CommsTabContainer.schema.ChatTab.schema.ChatStreams.values[i].value = false
                                                end
                                                for i = 1, #flag_table do
                                                    for j = 1, #values do
                                                        if values[j].flag == flag_table[i] then
                                                            ZomboidServerInterface.schema.PrimaryTab.schema.CommsTab.schema._CommsTabContainer.schema.ChatTab.schema.ChatStreams.values[j].value = true
                                                        end
                                                    end
                                                end
                                                return ZomboidServerInterface.schema.PrimaryTab.schema.CommsTab.schema._CommsTabContainer.schema.ChatTab.schema.ChatStreams.values
                                            end
                                        },
                                        ['ServerWelcomeMessage'] = {
                                            description = 'Server Welcome Message',
                                            default = 'Good luck. Dont die or eat mushrooms',
                                            type = String,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_server_welcome_message(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_server_welcome_message()
                                            end
                                        },
                                    }
                                },
                                ['DiscordTab'] = {
                                    type = Tab,
                                    description = 'Discord',
                                    schema = {
                                        ['DiscordEnable'] = {
                                            description = 'Discord Enable',
                                            default = false,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_discord_enable(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_discord_enable()
                                            end
                                        },
                                        ['DiscordToken'] = {
                                            description = 'Discord Token',
                                            default = '',
                                            type = String,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_discord_token(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_discord_token()
                                            end
                                        },
                                        ['DiscordChannel'] = {
                                            description = 'Discord Channel',
                                            default = '',
                                            type = String,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_discord_channel(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_discord_channel()
                                            end
                                        },
                                        ['DiscordChannelID'] = {
                                            description = 'Discord Channel ID',
                                            default = '',
                                            type = String,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_discord_channel_id(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_discord_channel_id()
                                            end
                                        },
                                    },
                                },
                            },
                        }
                    }
                },
                ['LootTab'] = {
                    type = Tab,
                    description = 'Loot',
                    schema = {
                        ['HoursForLootRespawn'] = {
                            description = 'Hours For Loot Respawn',
                            default = 4,
                            type = IntegerRange,
                            minimum = 1,
                            maximum = 2147483647,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_hours_for_loot_respawn(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_hours_for_loot_respawn()
                            end
                        },
                        ['MaxItemsForLootRespawn'] = {
                            description = 'Max Items For Loot Respawn',
                            default = 4,
                            type = IntegerRange,
                            minimum = 1,
                            maximum = 2147483647,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_max_items_for_loot_respawn(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_max_items_for_loot_respawn()
                            end
                        },
                        ['ConstructionPreventsLootRespawn'] = {
                            description = 'Construction Prevents Loot Respawn',
                            default = true,
                            type = Boolean,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_construction_prevents_loot_respawn(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_construction_prevents_loot_respawn()
                            end
                        },
                        ['ItemNumbersLimitPerContainer'] = {
                            description = 'Item Numbers Limit Per Container',
                            default = 0,
                            type = IntegerRange,
                            minimum = 0,
                            maximum = 9000,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_item_numbers_limit_per_container(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_item_numbers_limit_per_container()
                            end
                        },
                    },
                },
                ['FactionTab'] ={
                    type = Tab,
                    description = 'Faction',
                    schema = {
                        ['Faction'] = {
                            description = 'Faction',
                            default = true,
                            type = Boolean,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_faction(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_faction()
                            end
                        },
                        ['FactionDaySurvivedToCreate'] = {
                            description = 'Faction Day Survived To Create',
                            default = 0,
                            type = IntegerRange,
                            minimum = 0,
                            maximum = 2147483647,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_faction_day_survived_to_create(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_faction_day_survived_to_create()
                            end
                        },
                        ['FactionPlayersRequiredForTag'] = {
                            description = 'Faction Players Required For Tag',
                            default = 1,
                            type = IntegerRange,
                            minimum = 1,
                            maximum = 2147483647,
                            setter = function(v)
                                ZomboidServerInterface.instance:set_faction_players_required_for_tag(v)
                            end,
                            getter = function()
                                return ZomboidServerInterface.instance:get_faction_players_required_for_tag()
                            end
                        },
                    },
                },
                ['OtherTab'] = {
                    type = Tab,
                    description = 'Other',
                    schema = {
                        ['_OtherTabContainer'] = {
                            type = TabContainer,
                            tab_height = 11,
                            schema = {
                                ['MiscTab'] = {
                                    type = Tab,
                                    description = 'Misc',
                                    schema = {
                                        ['DoLuaChecksum'] = {
                                            description = 'Do Lua Checksum',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_do_lua_checksum(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_do_lua_checksum()
                                            end
                                        },
                                        ['AllowDestructionBySledgehammer'] = {
                                            description = 'Allow Destruction By Sledgehammer',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_allow_destruction_by_sledgehammer(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_allow_destruction_by_sledgehammer()
                                            end
                                        },
                                        ['SledgehammerOnlyInSafehouse'] = {
                                            description = 'Sledgehammer Only In Safehouse',
                                            default = false,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_sledgehammer_only_in_safehouse(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_sledgehammer_only_in_safehouse()
                                            end
                                        },
                                        ['MinutesPerPage'] = {
                                            description = 'Minutes Per Page (Decimal)',
                                            default = 1.0,
                                            type = FloatRange,
                                            minimum = 0.0,
                                            maximum = 60.0,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_minutes_per_page(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_minutes_per_page()
                                            end
                                        },
                                        ['SaveWorldEveryMinutes'] = {
                                            description = 'Save World Every Minutes',
                                            default = 0,
                                            type = IntegerRange,
                                            minimum = 0,
                                            maximum = 2147483647,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_save_world_every_n_minutes(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_save_world_every_n_minutes()
                                            end
                                        },
                                        ['FastForwardMultiplier'] = {
                                            description = 'Fast Forward Multiplier',
                                            default = 40.0,
                                            type = FloatRange,
                                            minimum = 1.00,
                                            maximum = 100.00,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_fast_forward_multiplier(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_fast_forward_multiplier()
                                            end
                                        },
                                        ['BloodSplatLifespanDays'] = {
                                            description = 'Blood Splat Lifespan Days',
                                            default = 0,
                                            type = IntegerRange,
                                            minimum = 0,
                                            maximum = 365,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_blood_splat_lifespan_days(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_blood_splat_lifespan_days()
                                            end
                                        },
                                        ['AllowNonAsciiUsername'] = {
                                            description = 'Allow Non-Ascii Username',
                                            default = false,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_allow_non_ascii_username(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_allow_non_ascii_username()
                                            end
                                        },
                                    },
                                },
                                ['AntiCheatTab'] = {
                                    type = Tab,
                                    description = 'AntiCheat',
                                    schema = {
                                        ['AntiCheatProtectionType1'] = {
                                            description = 'Anti Cheat Protection Type1',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_1(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_1()
                                            end
                                        },
                                        ['AntiCheatProtectionType2'] = {
                                            description = 'Anti Cheat Protection Type2',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_2(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_2()
                                            end
                                        },
                                        ['AntiCheatProtectionType3'] = {
                                            description = 'Anti-Cheat Protection Type3',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_3(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_3()
                                            end
                                        },
                                        ['AntiCheatProtectionType4'] = {
                                            description = 'Anti-Cheat Protection Type4',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_4(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_4()
                                            end
                                        },
                                        ['AntiCheatProtectionType5'] = {
                                            description = 'Anti-Cheat Protection Type5',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_5(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_5()
                                            end
                                        },
                                        ['AntiCheatProtectionType6'] = {
                                            description = 'Anti-Cheat Protection Type6',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_6(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_6()
                                            end
                                        },
                                        ['AntiCheatProtectionType7'] = {
                                            description = 'Anti-Cheat Protection Type7',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_7(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_7()
                                            end
                                        },
                                        ['AntiCheatProtectionType8'] = {
                                            description = 'Anti-Cheat Protection Type8',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_8(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_8()
                                            end
                                        },
                                        ['AntiCheatProtectionType9'] = {
                                            description = 'Anti-Cheat Protection Type9',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_9(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_9()
                                            end
                                        },
                                        ['AntiCheatProtectionType10'] = {
                                            description = 'Anti-Cheat Protection Type10',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_10(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_10()
                                            end
                                        },
                                        ['AntiCheatProtectionType11'] = {
                                            description = 'Anti-Cheat Protection Type11',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_11(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_11()
                                            end
                                        },
                                        ['AntiCheatProtectionType12'] = {
                                            description = 'Anti-Cheat Protection Type12',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_12(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_12()
                                            end
                                        },
                                        ['AntiCheatProtectionType13'] = {
                                            description = 'Anti-Cheat Protection Type13',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_13(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_13()
                                            end
                                        },
                                        ['AntiCheatProtectionType14'] = {
                                            description = 'Anti-Cheat Protection Type14',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_14(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_14()
                                            end
                                        },
                                        ['AntiCheatProtectionType15'] = {
                                            description = 'Anti-Cheat Protection Type15',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_15(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_15()
                                            end
                                        },
                                        ['AntiCheatProtectionType16'] = {
                                            description = 'Anti-Cheat Protection Type16',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_16(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_16()
                                            end
                                        },
                                        ['AntiCheatProtectionType17'] = {
                                            description = 'Anti-Cheat Protection Type17',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_17(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_17()
                                            end
                                        },
                                        ['AntiCheatProtectionType18'] = {
                                            description = 'Anti-Cheat Protection Type18',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_18(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_18()
                                            end
                                        },
                                        ['AntiCheatProtectionType19'] = {
                                            description = 'Anti-Cheat Protection Type19',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_19(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_19()
                                            end
                                        },
                                        ['AntiCheatProtectionType20'] = {
                                            description = 'Anti-Cheat Protection Type20',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_20(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_20()
                                            end
                                        },
                                        ['AntiCheatProtectionType21'] = {
                                            description = 'Anti-Cheat Protection Type21',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_21(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_21()
                                            end
                                        },
                                        ['AntiCheatProtectionType22'] = {
                                            description = 'Anti-Cheat Protection Type22',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_22(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_22()
                                            end
                                        },
                                        ['AntiCheatProtectionType23'] = {
                                            description = 'Anti-Cheat Protection Type23',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_23(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_23()
                                            end
                                        },
                                        ['AntiCheatProtectionType24'] = {
                                            description = 'Anti-Cheat Protection Type24',
                                            default = true,
                                            type = Boolean,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_24(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_24()
                                            end
                                        },
                                        ['AntiCheatProtectionType2ThresholdMultiplier'] = {
                                            description = 'Anti-Cheat Protection Type2 Threshold Multiplier',
                                            default = 3.0,
                                            type = FloatRange,
                                            minimum = 1.0,
                                            maximum = 10.0,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_2_threshold_multiplier(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_2_threshold_multiplier()
                                            end
                                        },
                                        ['AntiCheatProtectionType3ThresholdMultiplier'] = {
                                            description = 'Anti-Cheat Protection Type3 Threshold Multiplier',
                                            default = 1.0,
                                            type = FloatRange,
                                            minimum = 1.0,
                                            maximum = 10.0,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_3_threshold_multiplier(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_3_threshold_multiplier()
                                            end
                                        },
                                        ['AntiCheatProtectionType4ThresholdMultiplier'] = {
                                            description = 'Anti-Cheat Protection Type4 Threshold Multiplier',
                                            default = 1.0,
                                            type = FloatRange,
                                            minimum = 1.0,
                                            maximum = 10.0,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_4_threshold_multiplier(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_4_threshold_multiplier()
                                            end
                                        },
                                        ['AntiCheatProtectionType9ThresholdMultiplier'] = {
                                            description = 'Anti-Cheat Protection Type9 Threshold Multiplier',
                                            default = 1.0,
                                            type = FloatRange,
                                            minimum = 1.0,
                                            maximum = 10.0,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_9_threshold_multiplier(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_9_threshold_multiplier()
                                            end
                                        },
                                        ['AntiCheatProtectionType15ThresholdMultiplier'] = {
                                            description = 'Anti-Cheat Protection Type15 Threshold Multiplier',
                                            default = 1.0,
                                            type = FloatRange,
                                            minimum = 1.0,
                                            maximum = 10.0,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_15_threshold_multiplier(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_15_threshold_multiplier()
                                            end
                                        },
                                        ['AntiCheatProtectionType20ThresholdMultiplier'] = {
                                            description = 'Anti-Cheat Protection Type20 Threshold Multiplier',
                                            default = 1.0,
                                            type = FloatRange,
                                            minimum = 1.0,
                                            maximum = 10.0,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_20_threshold_multiplier(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_20_threshold_multiplier()
                                            end
                                        },
                                        ['AntiCheatProtectionType22ThresholdMultiplier'] = {
                                            description = 'Anti-Cheat Protection Type22 Threshold Multiplier',
                                            default = 1.0,
                                            type = FloatRange,
                                            minimum = 1.0,
                                            maximum = 10.0,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_22_threshold_multiplier(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_22_threshold_multiplier()
                                            end
                                        },
                                        ['AntiCheatProtectionType24ThresholdMultiplier'] = {
                                            description = 'Anti-Cheat Protection Type24 Threshold Multiplier',
                                            default = 6.0,
                                            type = FloatRange,
                                            minimum = 1.0,
                                            maximum = 10.0,
                                            setter = function(v)
                                                ZomboidServerInterface.instance:set_anti_cheat_protection_type_24_threshold_multiplier(v)
                                            end,
                                            getter = function()
                                                return ZomboidServerInterface.instance:get_anti_cheat_protection_type_24_threshold_multiplier()
                                            end
                                        }
                                    },
                                }
                            },
                        },
                    },
                },
            },
        },
        ['NoFire'] = {
            description = 'No Fire',
            default = false,
            type = Boolean,
            setter = function(v)
                ZomboidServerInterface.instance:set_no_fire(v)
            end,
            getter = function()
                return ZomboidServerInterface.instance:get_no_fire()
            end
        },
        ['SleepNeeded'] = {
            description = 'Sleep Needed',
            default = false,
            type = Boolean,
            setter = function(v)
                ZomboidServerInterface.instance:set_sleep_needed(v)
            end,
            getter = function()
                return ZomboidServerInterface.instance:get_sleep_needed()
            end
        },
        ['UPnP'] = {
            description = 'UPnP',
            default = false,
            type = Boolean,
            setter = function(v)
                ZomboidServerInterface.instance:set_upnp(v)
            end,
            getter = function()
                return ZomboidServerInterface.instance:get_upnp()
            end
        },
        ['SpeedLimit'] = {
            description = 'Speed Limit',
            default = 70.0,
            type = FloatRange,
            minimum = 10.0,
            maximum = 150.0,
            setter = function(v)
                ZomboidServerInterface.instance:set_speed_limit(v)
            end,
            getter = function()
                return ZomboidServerInterface.instance:get_speed_limit()
            end
        },
        ['CarEngineAttractionModifier'] = {
            description = 'Car Engine Attraction Modifier',
            default = 0.50,
            type = FloatRange,
            minimum = 0.0,
            maximum = 10.0,
            setter = function(v)
                ZomboidServerInterface.instance:set_car_engine_attraction_modifier(v)
            end,
            getter = function()
                return ZomboidServerInterface.instance:get_car_engine_attraction_modifier()
            end
        },

    }
}

register_plugin('Zomboid', 'Server Config', ZomboidServerInterface)
